/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Set;
import org.apache.commons.statistics.inference.InferenceException;

final class Arguments {
    private static final int TWO = 2;

    private Arguments() {
    }

    static void checkSignificance(double alpha) {
        if (alpha > 0.0 && alpha <= 0.5) {
            return;
        }
        throw new InferenceException("Not a significance: %s is out of range (0, 0.5]", alpha);
    }

    static int checkNonNegative(int v) {
        if (v < 0) {
            throw new InferenceException("%s is negative", v);
        }
        return v;
    }

    static void checkNonNegative(double v) {
        if (v >= 0.0) {
            return;
        }
        throw new InferenceException("%s is negative", v);
    }

    static void checkNonNegative(long[] values) {
        for (long v : values) {
            if (v >= 0L) continue;
            throw new InferenceException("%s is negative", v);
        }
    }

    static void checkNonNegative(long[][] values) {
        for (long[] v : values) {
            Arguments.checkNonNegative(v);
        }
    }

    static int checkStrictlyPositive(int v) {
        if (v <= 0) {
            throw new InferenceException("Number %s is not greater than 0", v);
        }
        return v;
    }

    static double checkStrictlyPositive(double v) {
        if (v > 0.0) {
            return v;
        }
        throw new InferenceException("Number %s is not greater than 0", v);
    }

    static void checkStrictlyPositive(double[] values) {
        for (double v : values) {
            if (v > 0.0) continue;
            throw new InferenceException("Number %s is not greater than 0", v);
        }
    }

    static double checkFinite(double v) {
        if (!Double.isFinite(v)) {
            throw new InferenceException("Non-finite input value: " + v);
        }
        return v;
    }

    static void checkNonNaN(double[] values) {
        for (double v : values) {
            if (!Double.isNaN(v)) continue;
            throw new InferenceException("NaN input value");
        }
    }

    static void checkRectangular(long[][] array) {
        int first = array[0].length;
        for (int i = 1; i < array.length; ++i) {
            if (array[i].length == first) continue;
            throw new InferenceException("Non-rectangular matrix: somes rows have size %s while others are %s", array[i].length, first);
        }
    }

    static void checkValuesRequiredSize(int size, int required) {
        if (size < required) {
            throw new InferenceException("Values size %s < %s", size, required);
        }
    }

    static void checkCategoriesRequiredSize(int size, int required) {
        if (size < required) {
            throw new InferenceException("Categories size %s < %s", size, required);
        }
    }

    static void checkValuesSizeMatch(int size1, int size2) {
        if (size1 != size2) {
            throw new InferenceException("Values size mismatch %s != %s", size1, size2);
        }
    }

    static <E extends Enum<E>> E checkOption(E v, Set<E> allowed) {
        if (!allowed.contains(v)) {
            throw new InferenceException("Invalid option: " + v);
        }
        return v;
    }

    static void checkTable(int[][] table) {
        if (table.length != 2 || table[0].length != 2 || table[1].length != 2) {
            throw new InferenceException("Require a 2-by-2 contingency table");
        }
        int a = table[0][0];
        int b = table[0][1];
        int c = table[1][0];
        int d = table[1][1];
        Arguments.checkNonNegative(a | b | c | d);
        long sum = (long)a + (long)b + (long)c + (long)d;
        if (sum > Integer.MAX_VALUE) {
            throw new InferenceException("%s > %s", sum, Integer.MAX_VALUE);
        }
        Arguments.checkStrictlyPositive((int)sum);
    }
}

