/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.ant._xbean.finder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameter<E extends Member>
implements AnnotatedElement {
    private final E declaringExecutable;
    private final int index;

    private Parameter(E declaringExecutable, int index) {
        if (declaringExecutable == null) {
            throw new NullPointerException("declaringExecutable");
        }
        this.declaringExecutable = declaringExecutable;
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.index = index;
    }

    public E getDeclaringExecutable() {
        return this.declaringExecutable;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationClass.equals(annotation.annotationType())) continue;
            Annotation result = annotation;
            return (T)result;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getParameterAnnotations()[this.index];
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter p = (Parameter)o;
        return this.declaringExecutable.equals(p.declaringExecutable) && this.index == p.index;
    }

    public int hashCode() {
        int result = this.declaringExecutable.hashCode() << 4;
        return result |= this.index;
    }

    public String toString() {
        return String.format("Parameter[index %s of %s]", this.index, this.declaringExecutable);
    }

    protected abstract Annotation[][] getParameterAnnotations();

    public static <T> Parameter<Constructor<T>> declaredBy(Constructor<T> ctor, int index) {
        return new Parameter<Constructor<T>>(ctor, index){

            @Override
            protected Annotation[][] getParameterAnnotations() {
                return ((Constructor)this.getDeclaringExecutable()).getParameterAnnotations();
            }
        };
    }

    public static Parameter<Method> declaredBy(Method method, int index) {
        return new Parameter<Method>(method, index){

            @Override
            protected Annotation[][] getParameterAnnotations() {
                return ((Method)this.getDeclaringExecutable()).getParameterAnnotations();
            }
        };
    }

    /* synthetic */ Parameter(Member x0, int x1, 1 x2) {
        this(x0, x1);
    }
}

