/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.weaver.Inflater;
import org.apache.commons.weaver.model.ScanRequest;
import org.apache.commons.weaver.model.ScanResult;
import org.apache.commons.weaver.model.Scanner;
import org.apache.commons.weaver.model.WeavableConstructorParameter;
import org.apache.commons.weaver.model.WeavableMethodParameter;
import org.apache.commons.weaver.model.WeaveInterest;
import org.apache.commons.weaver.utils.Annotations;
import org.apache.xbean.asm6.AnnotationVisitor;
import org.apache.xbean.asm6.ClassReader;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.FieldVisitor;
import org.apache.xbean.asm6.MethodVisitor;
import org.apache.xbean.asm6.Type;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.Parameter;
import org.apache.xbean.finder.archive.Archive;

class Finder
extends AnnotationFinder
implements Scanner {
    private static final int ASM_FLAGS = 7;
    private static final String INIT = "<init>";
    static final int ASM_VERSION = 393216;
    static final Predicate<AnnotationFinder.MethodInfo> CTOR = methodInfo -> INIT.equals(methodInfo.getName());
    static final ThreadLocal<Map<AnnotationFinder.Info, List<Annotation>>> CLASSFILE_ANNOTATIONS = ThreadLocal.withInitial(IdentityHashMap::new);
    final Map<AnnotationFinder.Info, List<Annotation>> classfileAnnotations;
    private final WithAnnotations withAnnotations = new WithAnnotations();
    private final Inflater inflater;

    static <T, U> Stream<U> typed(Class<U> type, Supplier<Stream<T>> stream) {
        return stream.get().filter(type::isInstance).map(type::cast);
    }

    static Predicate<Annotated<?>> hasAnnotation(Class<? extends Annotation> annotation) {
        return annotated -> annotated != null && annotated.isAnnotationPresent(annotation);
    }

    static <T> Predicate<T> isCtor(Function<? super T, AnnotationFinder.MethodInfo> xform) {
        return t -> CTOR.test((AnnotationFinder.MethodInfo)xform.apply(t));
    }

    Finder(Archive archive) {
        super(archive, false);
        this.classfileAnnotations = CLASSFILE_ANNOTATIONS.get();
        CLASSFILE_ANNOTATIONS.remove();
        this.inflater = new Inflater(this.classfileAnnotations);
        this.enableFindImplementations();
        this.enableFindSubclasses();
    }

    public WithAnnotations withAnnotations() {
        return this.withAnnotations;
    }

    protected void readClassDef(InputStream bytecode) throws IOException {
        try {
            new ClassReader(bytecode).accept((ClassVisitor)new Visitor(new AnnotationFinder.InfoBuildingVisitor((AnnotationFinder)this)), 7);
        }
        finally {
            bytecode.close();
        }
    }

    public AnnotationFinder select(Class<?> ... arg0) {
        throw new UnsupportedOperationException();
    }

    public AnnotationFinder select(Iterable<String> clazz) {
        throw new UnsupportedOperationException();
    }

    public AnnotationFinder select(String ... clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScanResult scan(ScanRequest request) {
        ScanResult result = new ScanResult();
        if (!request.isConstrained() || request.getSupertypes().contains(Object.class)) {
            for (Annotated<Class<?>> type2 : this.withAnnotations().getAllClasses()) {
                result.getWeavable((Class)type2.get()).addAnnotations(type2.getAnnotations());
            }
        } else {
            block9: for (WeaveInterest interest : request.getInterests()) {
                ElementType target = interest.target;
                switch (target) {
                    case PACKAGE: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedPackages(interest.annotationType)) {
                            result.getWeavable((Package)annotated.get()).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                    case TYPE: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedClasses(interest.annotationType)) {
                            result.getWeavable((Class)annotated.get()).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                    case METHOD: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedMethods(interest.annotationType)) {
                            result.getWeavable((Method)annotated.get()).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                    case CONSTRUCTOR: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedConstructors(interest.annotationType)) {
                            result.getWeavable((Constructor)annotated.get()).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                    case FIELD: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedFields(interest.annotationType)) {
                            result.getWeavable((Field)annotated.get()).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                    case PARAMETER: {
                        for (Annotated annotated : this.withAnnotations().findAnnotatedMethodParameters(interest.annotationType)) {
                            ((WeavableMethodParameter)result.getWeavable((Method)((Parameter)annotated.get()).getDeclaringExecutable()).getWeavableParameter(((Parameter)annotated.get()).getIndex())).addAnnotations(annotated.getAnnotations());
                        }
                        for (Annotated annotated : this.withAnnotations().findAnnotatedConstructorParameters(interest.annotationType)) {
                            ((WeavableConstructorParameter)result.getWeavable((Constructor)((Parameter)annotated.get()).getDeclaringExecutable()).getWeavableParameter(((Parameter)annotated.get()).getIndex())).addAnnotations(annotated.getAnnotations());
                        }
                        continue block9;
                    }
                }
            }
            request.getSupertypes().stream().map(this.withAnnotations()::findAssignableTypes).flatMap(Collection::stream).forEach(type -> result.getWeavable((Class)type.get()).addAnnotations(type.getAnnotations()));
        }
        return this.inflater.inflate(result);
    }

    Class<?> toClass(Type type) {
        Class<?> result;
        String className = type.getSort() == 9 ? type.getElementType().getClassName() : type.getClassName();
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                result = this.getArchive().loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
        if (type.getSort() == 9) {
            int[] dims = new int[type.getDimensions()];
            Arrays.fill(dims, 0);
            result = Array.newInstance(result, dims).getClass();
        }
        return result;
    }

    public final class WithAnnotations {
        private WithAnnotations() {
        }

        public List<Annotated<Package>> findAnnotatedPackages(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedPackages(annotation);
            return Finder.typed(AnnotationFinder.PackageInfo.class, Finder.this.getAnnotationInfos(annotation.getName())::stream).map(packageInfo -> {
                try {
                    return new IncludesClassfile<Package>(packageInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)packageInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        public List<Annotated<Class<?>>> getAllClasses() {
            return this.annotate(Finder.this.originalInfos.values());
        }

        public List<Annotated<Class<?>>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedClasses(annotation);
            return this.annotate(Finder.this.getAnnotationInfos(annotation.getName())).stream().filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        private List<Annotated<Class<?>>> annotate(Collection<? extends AnnotationFinder.Info> infos) {
            return Finder.typed(AnnotationFinder.ClassInfo.class, infos::stream).map(classInfo -> {
                try {
                    return new IncludesClassfile<Class>(classInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)classInfo));
                }
                catch (ClassNotFoundException e1) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<Annotated<Class<?>>> findAssignableTypes(Class<?> supertype) {
            List assignableTypes = supertype.isInterface() ? Finder.this.findImplementations(supertype) : Finder.this.findSubclasses(supertype);
            return assignableTypes.stream().map(Class::getName).map(Finder.this.classInfos::get).map(classInfo -> {
                try {
                    return new IncludesClassfile<Class>(classInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)classInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<Annotated<Method>> findAnnotatedMethods(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedMethods(annotation);
            return Finder.typed(AnnotationFinder.MethodInfo.class, Finder.this.getAnnotationInfos(annotation.getName())::stream).filter(CTOR.negate()).map(methodInfo -> {
                try {
                    return new IncludesClassfile<Method>((Method)methodInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)methodInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        public List<Annotated<Parameter<Method>>> findAnnotatedMethodParameters(Class<? extends Annotation> annotationType) {
            Finder.this.findAnnotatedMethodParameters(annotationType);
            return Finder.typed(AnnotationFinder.ParameterInfo.class, Finder.this.getAnnotationInfos(annotationType.getName())::stream).filter(Finder.isCtor(AnnotationFinder.ParameterInfo::getDeclaringMethod).negate()).map(parameterInfo -> {
                try {
                    Parameter parameter = parameterInfo.get();
                    return new IncludesClassfile<Parameter>(parameter, this.classfileAnnotationsFor((AnnotationFinder.Info)parameterInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotationType)).collect(Collectors.toList());
        }

        public List<Annotated<Constructor<?>>> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedConstructors(annotation);
            return Finder.typed(AnnotationFinder.MethodInfo.class, Finder.this.getAnnotationInfos(annotation.getName())::stream).filter(CTOR).map(methodInfo -> {
                try {
                    IncludesClassfile<Constructor> annotated = new IncludesClassfile<Constructor>((Constructor)methodInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)methodInfo));
                    return annotated;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        public List<Annotated<Parameter<Constructor<?>>>> findAnnotatedConstructorParameters(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedConstructorParameters(annotation);
            return Finder.typed(AnnotationFinder.ParameterInfo.class, Finder.this.getAnnotationInfos(annotation.getName())::stream).filter(Finder.isCtor(AnnotationFinder.ParameterInfo::getDeclaringMethod)).map(parameterInfo -> {
                try {
                    Parameter parameter = parameterInfo.get();
                    return new IncludesClassfile<Parameter>(parameter, this.classfileAnnotationsFor((AnnotationFinder.Info)parameterInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        public List<Annotated<Field>> findAnnotatedFields(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedFields(annotation);
            return Finder.typed(AnnotationFinder.FieldInfo.class, Finder.this.getAnnotationInfos(annotation.getName())::stream).map(fieldInfo -> {
                try {
                    return new IncludesClassfile<Field>((Field)fieldInfo.get(), this.classfileAnnotationsFor((AnnotationFinder.Info)fieldInfo));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(Finder.hasAnnotation(annotation)).collect(Collectors.toList());
        }

        private List<Annotation> classfileAnnotationsFor(AnnotationFinder.Info info) {
            return Finder.this.classfileAnnotations.computeIfAbsent(info, k -> new ArrayList());
        }
    }

    private static class IncludesClassfile<T extends AnnotatedElement>
    implements Annotated<T> {
        private final T annotatedElement;
        private final Annotation[] annotations;

        IncludesClassfile(T annotatedElement, List<Annotation> classfileAnnotations) {
            this(annotatedElement, classfileAnnotations.toArray(new Annotation[0]));
        }

        IncludesClassfile(T annotatedElement, Annotation[] classfileAnnotations) {
            this.annotatedElement = annotatedElement;
            this.annotations = (Annotation[])ArrayUtils.addAll((Object[])annotatedElement.getAnnotations(), (Object[])classfileAnnotations);
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation prospect : this.annotations) {
                if (!prospect.annotationType().equals(annotationType)) continue;
                Annotation result = prospect;
                return (A)result;
            }
            return null;
        }

        public Annotation[] getAnnotations() {
            Annotation[] result = new Annotation[this.annotations.length];
            System.arraycopy(this.annotations, 0, result, 0, this.annotations.length);
            return result;
        }

        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        public T get() {
            return this.annotatedElement;
        }
    }

    public class Visitor
    extends ClassVisitor {
        private final AnnotationFinder.InfoBuildingVisitor wrapped;

        Visitor(AnnotationFinder.InfoBuildingVisitor wrapped) {
            super(393216, (ClassVisitor)wrapped);
            this.wrapped = wrapped;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor toWrap = this.wrapped.visitField(access, name, desc, signature, value);
            AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)this.wrapped.getInfo();
            Type fieldType = Type.getType((String)desc);
            AnnotationFinder.FieldInfo testFieldInfo = null;
            for (int i = classInfo.getFields().size() - 1; i >= 0; --i) {
                String type;
                AnnotationFinder.FieldInfo atI = (AnnotationFinder.FieldInfo)classInfo.getFields().get(i);
                if (!atI.getName().equals(name) || !StringUtils.equals((CharSequence)(type = atI.getType()), (CharSequence)fieldType.getClassName()) && !StringUtils.equals((CharSequence)type, (CharSequence)fieldType.getDescriptor())) continue;
                testFieldInfo = atI;
                break;
            }
            if (testFieldInfo == null) {
                return toWrap;
            }
            final AnnotationFinder.FieldInfo fieldInfo = testFieldInfo;
            return new FieldVisitor(393216, toWrap){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
                    return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, (AnnotationFinder.Info)fieldInfo);
                }
            };
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor toWrap = this.wrapped.visitMethod(access, name, desc, signature, exceptions);
            AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)this.wrapped.getInfo();
            AnnotationFinder.MethodInfo compareMethodInfo = new AnnotationFinder.MethodInfo((AnnotationFinder)Finder.this, classInfo, name, desc);
            if (!compareMethodInfo.isConstructor() && !this.isJavaIdentifier(name)) {
                return toWrap;
            }
            AnnotationFinder.MethodInfo testMethodInfo = null;
            for (int i = classInfo.getMethods().size() - 1; i >= 0; --i) {
                AnnotationFinder.MethodInfo atI = (AnnotationFinder.MethodInfo)classInfo.getMethods().get(i);
                if (!atI.getName().equals(name) || !StringUtils.equals((CharSequence)atI.getDescriptor(), (CharSequence)desc)) continue;
                testMethodInfo = atI;
                break;
            }
            if (testMethodInfo == null) {
                return toWrap;
            }
            final AnnotationFinder.MethodInfo methodInfo = testMethodInfo;
            return new MethodVisitor(393216, toWrap){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
                    return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, (AnnotationFinder.Info)methodInfo);
                }

                public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitParameterAnnotation(param, desc, visible);
                    if (visible) {
                        return toWrap;
                    }
                    AnnotationFinder.ParameterInfo parameterInfo = null;
                    for (int i = methodInfo.getParameters().size() - 1; i >= 0; --i) {
                        AnnotationFinder.ParameterInfo atI = (AnnotationFinder.ParameterInfo)methodInfo.getParameters().get(i);
                        if (!atI.getName().equals(Integer.toString(param))) continue;
                        parameterInfo = atI;
                        break;
                    }
                    return parameterInfo == null ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, (AnnotationFinder.Info)parameterInfo);
                }
            };
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
            return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, this.wrapped.getInfo());
        }

        private boolean isJavaIdentifier(String toCheck) {
            if (toCheck.isEmpty() || !Character.isJavaIdentifierStart(toCheck.charAt(0))) {
                return false;
            }
            for (char chr : toCheck.substring(1).toCharArray()) {
                if (Character.isJavaIdentifierPart(chr)) continue;
                return false;
            }
            return true;
        }
    }

    private class TopLevelAnnotationInflater
    extends AnnotationInflater {
        private final AnnotationFinder.Info info;

        TopLevelAnnotationInflater(String desc, AnnotationVisitor wrapped, AnnotationFinder.Info info) {
            super(desc, wrapped);
            this.info = info;
        }

        public void visitEnd() {
            super.visitEnd();
            CLASSFILE_ANNOTATIONS.get().computeIfAbsent(this.info, k -> new ArrayList()).add(this.inflate());
        }
    }

    private abstract class AnnotationCapturer
    extends AnnotationVisitor {
        AnnotationCapturer(AnnotationVisitor wrapped) {
            super(393216, wrapped);
        }

        protected abstract void storeValue(String var1, Object var2);

        public void visit(String name, Object value) {
            this.storeValue(name, value);
        }

        public AnnotationVisitor visitAnnotation(final String name, String desc) {
            final AnnotationCapturer owner = this;
            return new AnnotationInflater(desc, super.visitAnnotation(name, desc)){

                public void visitEnd() {
                    owner.storeValue(name, this.inflate());
                }
            };
        }

        public AnnotationVisitor visitArray(final String name) {
            final AnnotationCapturer owner = this;
            final ArrayList values = new ArrayList();
            return new AnnotationCapturer(super.visitArray(name)){

                public void visitEnd() {
                    owner.storeValue(name, values.toArray());
                    super.visitEnd();
                }

                @Override
                protected void storeValue(String name2, Object value) {
                    values.add(value);
                }
            };
        }

        public void visitEnum(String name, String desc, String value) {
            Class<Enum> enumType;
            super.visitEnum(name, desc, value);
            try {
                enumType = Class.forName(Type.getType((String)desc).getClassName()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Enum enumValue = Enum.valueOf(enumType, value);
            this.storeValue(name, enumValue);
        }
    }

    private abstract class AnnotationInflater
    extends AnnotationCapturer {
        final Class<? extends Annotation> annotationType;
        final Map<String, Object> elements;

        AnnotationInflater(String desc, AnnotationVisitor wrapped) {
            super(wrapped);
            this.elements = new LinkedHashMap<String, Object>();
            this.annotationType = Finder.this.toClass(Type.getType((String)desc)).asSubclass(Annotation.class);
        }

        Annotation inflate() {
            return Annotations.instanceOf(this.annotationType, this.elements);
        }

        @Override
        protected void storeValue(String name, Object value) {
            Object toStore = value;
            Validate.notNull((Object)toStore, (String)"null annotation element", (Object[])new Object[0]);
            if (toStore.getClass().isArray()) {
                Class<?> requiredType;
                try {
                    requiredType = this.annotationType.getDeclaredMethod(name, new Class[0]).getReturnType();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!requiredType.isInstance(toStore)) {
                    int len = Array.getLength(toStore);
                    Object typedArray = Array.newInstance(requiredType.getComponentType(), len);
                    for (int i = 0; i < len; ++i) {
                        Class<?> element = Array.get(toStore, i);
                        if (element instanceof Type) {
                            element = Finder.this.toClass((Type)element);
                        }
                        Array.set(typedArray, i, element);
                    }
                    toStore = typedArray;
                }
            } else if (toStore instanceof Type) {
                toStore = Finder.this.toClass((Type)toStore);
            }
            this.elements.put(name, toStore);
        }
    }
}

