/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.creadur.tentacles.Archive;
import org.apache.creadur.tentacles.Configuration;
import org.apache.creadur.tentacles.FileSystem;
import org.apache.creadur.tentacles.IOSystem;
import org.apache.creadur.tentacles.Layout;
import org.apache.creadur.tentacles.License;
import org.apache.creadur.tentacles.LicenseType;
import org.apache.creadur.tentacles.Licenses;
import org.apache.creadur.tentacles.NexusClient;
import org.apache.creadur.tentacles.Notice;
import org.apache.creadur.tentacles.Platform;
import org.apache.creadur.tentacles.Reports;
import org.apache.creadur.tentacles.RepositoryType;
import org.apache.creadur.tentacles.Templates;
import org.apache.creadur.tentacles.TentaclesResources;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Main {
    private static final Logger log;
    private static final String CRAWL_PATTERN = ".*\\.(jar|zip|war|ear|rar|tar.gz)";
    private final Reports reports;
    private final Licenses licenses;
    private final Layout layout;
    private final Platform platform;
    private final Configuration configuration;
    private final FileSystem fileSystem;
    private final IOSystem ioSystem;
    private final TentaclesResources tentaclesResources;
    private final Templates templates;

    public Main(String ... args) throws Exception {
        this(new Configuration(args), Platform.aPlatform());
    }

    public Main(Configuration configuration, Platform platform) throws Exception {
        this(configuration, platform, new Templates(platform), new Layout(platform, configuration));
    }

    public Main(Configuration configuration, Platform platform, Templates templates, Layout layout) throws Exception {
        this.platform = platform;
        this.configuration = configuration;
        this.layout = layout;
        this.fileSystem = platform.getFileSystem();
        this.ioSystem = platform.getIoSystem();
        this.tentaclesResources = platform.getTentaclesResources();
        this.templates = templates;
        this.reports = new Reports();
        log.info((Object)("Remote repository: " + this.configuration.getStagingRepositoryURI()));
        log.info((Object)("Local root directory: " + this.layout.getLocalRootDirectory()));
        this.tentaclesResources.copyTo("legal/style.css", new File(this.layout.getOutputDirectory(), "style.css"));
        this.licenses = LicenseType.loadLicensesFrom(platform);
    }

    public static void main(String[] args) throws Exception {
        log.info((Object)"Launching Apache Tentacles ...");
        if (args == null || args.length < 1) {
            log.error((Object)"Error: Input parameter missing - you did not specify any component to run Apache Tentacles on.");
            log.error((Object)"Please launch Apache Tentacles with an URI to work on such as 'https://repository.apache.org/content/repositories/orgapachecreadur-1000/'.");
        } else {
            new Main(args).main();
        }
    }

    private void main() throws Exception {
        this.unpackContents(this.mirrorRepositoryFrom(this.configuration));
        this.reportOn(this.archivesIn(this.layout.getRepositoryDirectory()));
    }

    private List<Archive> archivesIn(File repository) {
        List<File> jars = this.fileSystem.documentsFrom(repository);
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (File file : jars) {
            Archive archive = new Archive(file, this.fileSystem, this.layout);
            archives.add(archive);
        }
        return archives;
    }

    private void reportOn(List<Archive> archives) throws IOException {
        this.templates.template("legal/archives.vm").add("archives", archives).add("reports", this.reports).write(new File(this.layout.getOutputDirectory(), "archives.html"));
        this.reportLicenses(archives);
        this.reportNotices(archives);
        this.reportDeclaredLicenses(archives);
        this.reportDeclaredNotices(archives);
    }

    private void reportLicenses(List<Archive> archives) throws IOException {
        this.initLicenses(archives);
        this.templates.template("legal/licenses.vm").add("licenses", this.getLicenses(archives)).add("reports", this.reports).write(new File(this.layout.getOutputDirectory(), "licenses.html"));
    }

    private void initLicenses(List<Archive> archives) throws IOException {
        HashMap<License, License> licenses = new HashMap<License, License>();
        for (Archive archive : archives) {
            List<File> files = this.fileSystem.licensesFrom(archive.contentsDirectory());
            for (File file : files) {
                License license = this.licenses.from(file);
                License existing = (License)licenses.get(license);
                if (existing == null) {
                    licenses.put(license, license);
                    existing = license;
                }
                existing.getLocations().add(file);
                existing.getArchives().add(archive);
                archive.getLicenses().add(existing);
            }
        }
    }

    private Collection<License> getLicenses(List<Archive> archives) {
        LinkedHashSet<License> licenses = new LinkedHashSet<License>();
        for (Archive archive : archives) {
            licenses.addAll(archive.getLicenses());
        }
        return licenses;
    }

    private void reportDeclaredLicenses(List<Archive> archives) throws IOException {
        for (Archive archive : archives) {
            this.classifyLicenses(archive);
        }
        for (Archive archive : archives) {
            this.templates.template("legal/archive-licenses.vm").add("archive", archive).add("reports", this.reports).write(new File(this.layout.getOutputDirectory(), this.reports.licenses(archive)));
        }
    }

    private void classifyLicenses(Archive archive) throws IOException {
        HashSet<License> undeclared = new HashSet<License>(archive.getLicenses());
        File contents = archive.contentsDirectory();
        List<File> files = this.fileSystem.licensesDeclaredIn(contents);
        for (File file : files) {
            undeclared.remove(this.licenses.from(file));
        }
        archive.getOtherLicenses().addAll(undeclared);
        HashSet<License> declared = new HashSet<License>(archive.getLicenses());
        declared.removeAll(undeclared);
        archive.getDeclaredLicenses().addAll(declared);
        for (License license : undeclared) {
            for (License declare : declared) {
                if (!license.implies(declare)) continue;
                archive.getOtherLicenses().remove(license);
            }
        }
    }

    private void reportDeclaredNotices(List<Archive> archives) throws IOException {
        for (Archive archive : archives) {
            HashSet<Notice> undeclared = new HashSet<Notice>(archive.getNotices());
            File contents = archive.contentsDirectory();
            List<File> files = this.fileSystem.noticesDeclaredIn(contents);
            for (File file : files) {
                Notice notice = new Notice(this.ioSystem.slurp(file));
                undeclared.remove(notice);
            }
            archive.getOtherNotices().addAll(undeclared);
            HashSet<Notice> declared = new HashSet<Notice>(archive.getNotices());
            declared.removeAll(undeclared);
            archive.getDeclaredNotices().addAll(declared);
            for (Notice notice : undeclared) {
                for (Notice declare : declared) {
                    if (!notice.implies(declare)) continue;
                    archive.getOtherLicenses().remove(notice);
                }
            }
            this.templates.template("legal/archive-notices.vm").add("archive", archive).add("reports", this.reports).write(new File(this.layout.getOutputDirectory(), this.reports.notices(archive)));
        }
    }

    private void reportNotices(List<Archive> archives) throws IOException {
        HashMap<Notice, Notice> notices = new HashMap<Notice, Notice>();
        for (Archive archive : archives) {
            List<File> noticeDocuments = this.fileSystem.noticesOnly(archive.contentsDirectory());
            for (File file : noticeDocuments) {
                Notice notice = new Notice(this.ioSystem.slurp(file));
                Notice existing = (Notice)notices.get(notice);
                if (existing == null) {
                    notices.put(notice, notice);
                    existing = notice;
                }
                existing.getLocations().add(file);
                existing.getArchives().add(archive);
                archive.getNotices().add(existing);
            }
        }
        this.templates.template("legal/notices.vm").add("notices", notices.values()).add("reports", this.reports).write(new File(this.layout.getOutputDirectory(), "notices.html"));
    }

    private void unpackContents(Set<File> files) throws IOException {
        for (File file : files) {
            this.unpack(file);
        }
    }

    private Set<File> mirrorRepositoryFrom(Configuration configuration) throws IOException {
        HashSet<File> files;
        block3: {
            block2: {
                files = new HashSet<File>();
                if (!RepositoryType.HTTP.isRepositoryFor(configuration)) break block2;
                NexusClient client = new NexusClient(this.platform);
                Set<URI> resources = client.crawl(configuration.getStagingRepositoryURI());
                for (URI uri : resources) {
                    if (!uri.getPath().matches(CRAWL_PATTERN)) continue;
                    files.add(client.download(uri, this.mirroredFrom(uri)));
                }
                break block3;
            }
            if (!RepositoryType.LOCAL_FILE_SYSTEM.isRepositoryFor(configuration)) break block3;
            File file = new File(configuration.getStagingRepositoryURI());
            List<File> collect = this.platform.getFileSystem().archivesInPath(file, configuration.getFileRepositoryPathNameFilter());
            for (File f : collect) {
                files.add(this.copyToMirror(f));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack(File archive) throws IOException {
        log.info((Object)("Unpack " + archive));
        try {
            ZipInputStream zip = this.ioSystem.unzip(archive);
            File contents = new Archive(archive, this.fileSystem, this.layout).contentsDirectory();
            try {
                ZipEntry entry = null;
                while ((entry = zip.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    String path = entry.getName();
                    File fileEntry = new File(contents, path);
                    this.fileSystem.mkparent(fileEntry);
                    this.ioSystem.copy((InputStream)zip, fileEntry);
                    if (!fileEntry.getName().endsWith(".jar")) continue;
                    this.unpack(fileEntry);
                }
            }
            finally {
                this.ioSystem.close(zip);
            }
        }
        catch (IOException e) {
            log.error((Object)("Not a zip " + archive));
        }
    }

    private File copyToMirror(File src) throws IOException {
        URI uri = src.toURI();
        File file = this.mirroredFrom(uri);
        log.info((Object)("Copy " + uri));
        this.fileSystem.mkparent(file);
        this.ioSystem.copy(this.ioSystem.read(src), file);
        return file;
    }

    private File mirroredFrom(URI uri) {
        String name = uri.toString().replace(this.configuration.getStagingRepositoryURI().toString(), "").replaceFirst("^/", "");
        return new File(this.layout.getRepositoryDirectory(), name);
    }

    static {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((org.apache.log4j.Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        root.setLevel(Level.INFO);
        log = Logger.getLogger(Main.class);
    }
}

