/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.interceptors;

import java.io.InputStream;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.metrics.ExchangeMetrics;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.interceptors.AbstractMetricsInterceptor;
import org.apache.cxf.metrics.interceptors.CountingInputStream;

public class MetricsMessageInInterceptor
extends AbstractMetricsInterceptor {
    public MetricsMessageInInterceptor(MetricsProvider[] p) {
        super("receive", p);
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.isRequestor(message)) {
            ExchangeMetrics ctx = this.getExchangeMetrics(message, true);
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in != null) {
                CountingInputStream newIn = new CountingInputStream(in);
                message.setContent(InputStream.class, (Object)newIn);
                message.getExchange().put(CountingInputStream.class, (Object)newIn);
            }
            ctx.start();
        }
    }

    public void handleFault(Message message) {
        if (this.isRequestor(message)) {
            this.stop(message);
        } else if (message.getExchange().isOneWay()) {
            this.stop(message);
        }
    }
}

