/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.util.HttpString;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;

public class CxfDisallowedMethodsHandler
implements CXFUndertowHttpHandler {
    private HttpHandler next;
    private DisallowedMethodsHandler buildDisallowedMethodHandler;
    private String[] methods;

    public CxfDisallowedMethodsHandler(String[] methods) {
        this.setMethods(methods);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.buildDisallowedMethodHandler == null) {
            this.buildDisallowedMethodHandler();
        }
        this.buildDisallowedMethodHandler.handleRequest(exchange);
    }

    @Override
    public void setNext(HttpHandler nextHandler) {
        this.next = nextHandler;
    }

    private void buildDisallowedMethodHandler() {
        HttpString[] strings = new HttpString[this.methods.length];
        for (int i = 0; i < this.methods.length; ++i) {
            strings[i] = new HttpString(this.methods[i]);
        }
        HttpHandler handler = this.next;
        this.buildDisallowedMethodHandler = new DisallowedMethodsHandler(handler, strings);
    }

    public String[] getMethods() {
        return this.methods;
    }

    public void setMethods(String[] methods) {
        this.methods = methods;
    }
}

