/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.events;

import org.ehcache.core.events.StoreEventSink;
import org.ehcache.impl.internal.events.AbstractStoreEventDispatcher;
import org.ehcache.impl.internal.events.FudgingInvocationScopedEventSink;

public class ThreadLocalStoreEventDispatcher<K, V>
extends AbstractStoreEventDispatcher<K, V> {
    private final ThreadLocal<StoreEventSink<K, V>> tlEventSink = new ThreadLocal();
    private final ThreadLocal<Integer> usageDepth = new ThreadLocal();

    public ThreadLocalStoreEventDispatcher(int dispatcherConcurrency) {
        super(dispatcherConcurrency);
    }

    @Override
    public StoreEventSink<K, V> eventSink() {
        if (this.getListeners().isEmpty()) {
            StoreEventSink noOpEventSink = NO_OP_EVENT_SINK;
            return noOpEventSink;
        }
        StoreEventSink<K, V> eventSink = this.tlEventSink.get();
        if (eventSink == null) {
            eventSink = new FudgingInvocationScopedEventSink(this.getFilters(), this.isEventOrdering(), this.getOrderedQueues(), this.getListeners());
            this.tlEventSink.set(eventSink);
            this.usageDepth.set(0);
        } else {
            this.usageDepth.set(this.usageDepth.get() + 1);
        }
        return eventSink;
    }

    @Override
    public void releaseEventSink(StoreEventSink<K, V> eventSink) {
        if (eventSink != NO_OP_EVENT_SINK) {
            int depthValue = this.usageDepth.get();
            if (depthValue == 0) {
                try {
                    super.releaseEventSink(eventSink);
                }
                finally {
                    this.tlEventSink.remove();
                    this.usageDepth.remove();
                }
            } else {
                this.usageDepth.set(depthValue - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseEventSinkAfterFailure(StoreEventSink<K, V> eventSink, Throwable throwable) {
        if (eventSink != NO_OP_EVENT_SINK) {
            int depthValue = this.usageDepth.get();
            if (depthValue == 0) {
                try {
                    super.releaseEventSinkAfterFailure(eventSink, throwable);
                }
                finally {
                    this.tlEventSink.remove();
                    this.usageDepth.remove();
                }
            } else {
                this.usageDepth.set(depthValue - 1);
            }
        }
    }
}

