/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.XMLConfigurationUtil;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LegacyJMSConfiguration
implements Deployable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CONFIGURATION_SCHEMA_URL = "schema/artemis-jms.xsd";
    private static final String CONFIGURATION_SCHEMA_ROOT_ELEMENT = "jms";
    private static final String NAME_ATTR = "name";
    private static final String QUEUE_NODE_NAME = "queue";
    private static final String QUEUE_SELECTOR_NODE_NAME = "selector";
    private static final String TOPIC_NODE_NAME = "topic";
    private static final String JMX_DOMAIN_NAME = "jmx-domain";
    private static final boolean DEFAULT_QUEUE_DURABILITY = true;
    private URL configurationUrl;
    final Configuration configuration;

    public LegacyJMSConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void parse(Element config, URL url) throws Exception {
        this.parseConfiguration(config);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isParsed() {
        return false;
    }

    @Override
    public String getRootElement() {
        return CONFIGURATION_SCHEMA_ROOT_ELEMENT;
    }

    @Override
    public void buildService(ActiveMQSecurityManager securityManager, MBeanServer mBeanServer, Map<String, Deployable> deployables, Map<String, ActiveMQComponent> components, ActivateCallback activateCallback) throws Exception {
    }

    @Override
    public String getSchema() {
        return CONFIGURATION_SCHEMA_URL;
    }

    public void parseConfiguration(InputStream input) throws Exception {
        Element e = XMLUtil.streamToElement((InputStream)input);
        NodeList children = e.getElementsByTagName(CONFIGURATION_SCHEMA_ROOT_ELEMENT);
        if (children.getLength() > 0) {
            this.parseConfiguration(children.item(0));
        }
    }

    public void parseConfiguration(Node rootnode) throws Exception {
        String[] elements;
        Element e = (Element)rootnode;
        for (String element : elements = new String[]{QUEUE_NODE_NAME, TOPIC_NODE_NAME}) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                Node keyNode = node.getAttributes().getNamedItem(NAME_ATTR);
                if (keyNode == null) {
                    logger.warn("Configuration missing jms key {}", (Object)node);
                    continue;
                }
                if (node.getNodeName().equals(TOPIC_NODE_NAME)) {
                    this.parseTopicConfiguration(node);
                    continue;
                }
                if (!node.getNodeName().equals(QUEUE_NODE_NAME)) continue;
                this.parseQueueConfiguration(node);
            }
        }
    }

    public void parseTopicConfiguration(Node node) throws Exception {
        String topicName = node.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
        this.configuration.addAddressConfiguration(new CoreAddressConfiguration().setName(topicName).addRoutingType(RoutingType.MULTICAST));
    }

    public void parseQueueConfiguration(Node node) throws Exception {
        Element e = (Element)node;
        NamedNodeMap atts = node.getAttributes();
        String queueName = atts.getNamedItem(NAME_ATTR).getNodeValue();
        String selectorString = null;
        boolean durable = XMLConfigurationUtil.getBoolean(e, "durable", true);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!QUEUE_SELECTOR_NODE_NAME.equals(child.getNodeName())) continue;
            Node selectorNode = child;
            Node attNode = selectorNode.getAttributes().getNamedItem("string");
            selectorString = attNode.getNodeValue();
        }
        this.configuration.addAddressConfiguration(new CoreAddressConfiguration().setName(queueName).addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(new QueueConfiguration(queueName).setFilterString(selectorString).setDurable(Boolean.valueOf(durable)).setRoutingType(RoutingType.ANYCAST)));
    }
}

