/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;

public final class Validators {
    public static final Validator NO_CHECK = (name, value) -> value;
    public static final Validator<String> NOT_NULL_OR_EMPTY = (name, value) -> {
        if (value == null || value.isEmpty()) {
            throw ActiveMQMessageBundle.BUNDLE.emptyOrNull(name);
        }
        return value;
    };
    public static final Validator<Number> GT_ZERO = (name, value) -> {
        if (value.doubleValue() > 0.0) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.greaterThanZero(name, (Number)value);
    };
    public static final Validator<Number> PERCENTAGE = (name, value) -> {
        if (value == null || value.intValue() < 0 || value.intValue() > 100) {
            throw ActiveMQMessageBundle.BUNDLE.notPercent(name, (Number)value);
        }
        return value;
    };
    public static final Validator<Number> PERCENTAGE_OR_MINUS_ONE = (name, value) -> {
        if (value == null || (value.intValue() < 0 || value.intValue() > 100) && value.intValue() != -1) {
            throw ActiveMQMessageBundle.BUNDLE.notPercentOrMinusOne(name, (Number)value);
        }
        return value;
    };
    public static final Validator<Number> GE_ZERO = (name, value) -> {
        if (value.doubleValue() >= 0.0) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.greaterThanZero(name, (Number)value);
    };
    public static final Validator<Number> LE_ONE = (name, value) -> {
        if (value.doubleValue() <= 1.0) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.lessThanOrEqualToOne(name, (Number)value);
    };
    public static final Validator<Number> MINUS_ONE_OR_GT_ZERO = (name, value) -> {
        if (value.doubleValue() == -1.0 || value.doubleValue() > 0.0) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.greaterThanMinusOne(name, (Number)value);
    };
    public static final Validator<Number> MINUS_ONE_OR_GE_ZERO = (name, value) -> {
        if (value.doubleValue() == -1.0 || value.doubleValue() >= 0.0) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.greaterThanZeroOrMinusOne(name, (Number)value);
    };
    public static final Validator<Number> POSITIVE_INT = (name, value) -> {
        if (value.longValue() > 0L && value.longValue() <= Integer.MAX_VALUE) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.inRangeOfPositiveInt(name, (Number)value);
    };
    public static final Validator<Number> POSITIVE_POWER_OF_TWO = (name, value) -> {
        if ((value.longValue() & value.longValue() - 1L) == 0L && value.longValue() > 0L) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.positivePowerOfTwo(name, (Number)value);
    };
    public static final Validator<Number> MINUS_ONE_OR_POSITIVE_INT = (name, value) -> {
        if (value.longValue() == -1L || value.longValue() > 0L && value.longValue() <= Integer.MAX_VALUE) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.inRangeOfPositiveIntThanMinusOne(name, (Number)value);
    };
    public static final Validator<Number> THREAD_PRIORITY_RANGE = (name, value) -> {
        if (value.intValue() >= 1 && value.intValue() <= 10) {
            return value;
        }
        throw ActiveMQMessageBundle.BUNDLE.mustbeBetween(name, 1, 10, value);
    };
    public static final Validator<String> JOURNAL_TYPE = (name, value) -> {
        if (value == null || !EnumSet.allOf(JournalType.class).contains((Object)JournalType.valueOf(value))) {
            throw ActiveMQMessageBundle.BUNDLE.invalidJournalType((String)value);
        }
        return value;
    };
    public static final Validator<String> ADDRESS_FULL_MESSAGE_POLICY_TYPE = (name, value) -> {
        if (value == null || !value.equals(AddressFullMessagePolicy.PAGE.toString()) && !value.equals(AddressFullMessagePolicy.DROP.toString()) && !value.equals(AddressFullMessagePolicy.BLOCK.toString()) && !value.equals(AddressFullMessagePolicy.FAIL.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidAddressFullPolicyType((String)value);
        }
        return value;
    };
    public static final Validator<String> PAGE_FULL_MESSAGE_POLICY_TYPE = (name, value) -> {
        if (value == null || !value.equals(PageFullMessagePolicy.DROP.toString()) && !value.equals(PageFullMessagePolicy.FAIL.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidAddressFullPolicyType((String)value);
        }
        return value;
    };
    public static final Validator<String> SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT = (name, value) -> {
        if (value == null || !value.equals(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND.toString()) && !value.equals(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE.toString()) && !value.equals(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_HOUR.toString()) && !value.equals(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_DAY.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidSlowConsumerThresholdMeasurementUnit((String)value);
        }
        return value;
    };
    public static final Validator<String> SLOW_CONSUMER_POLICY_TYPE = (name, value) -> {
        if (value == null || !value.equals(SlowConsumerPolicy.KILL.toString()) && !value.equals(SlowConsumerPolicy.NOTIFY.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidSlowConsumerPolicyType((String)value);
        }
        return value;
    };
    public static final Validator<String> DELETION_POLICY_TYPE = (name, value) -> {
        if (value == null || !value.equals(DeletionPolicy.OFF.toString()) && !value.equals(DeletionPolicy.FORCE.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidDeletionPolicyType((String)value);
        }
        return value;
    };
    public static final Validator<String> MESSAGE_LOAD_BALANCING_TYPE = (name, value) -> {
        if (value == null || !value.equals(MessageLoadBalancingType.OFF.toString()) && !value.equals(MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION.toString()) && !value.equals(MessageLoadBalancingType.STRICT.toString()) && !value.equals(MessageLoadBalancingType.ON_DEMAND.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidMessageLoadBalancingType((String)value);
        }
        return value;
    };
    public static final Validator<String> ROUTING_TYPE = (name, value) -> {
        if (value == null || !value.equals(RoutingType.ANYCAST.toString()) && !value.equals(RoutingType.MULTICAST.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidRoutingType((String)value);
        }
        return value;
    };
    public static final Validator<String> COMPONENT_ROUTING_TYPE = (name, value) -> {
        if (value == null || !value.equals(ComponentConfigurationRoutingType.ANYCAST.toString()) && !value.equals(ComponentConfigurationRoutingType.MULTICAST.toString()) && !value.equals(ComponentConfigurationRoutingType.PASS.toString()) && !value.equals(ComponentConfigurationRoutingType.STRIP.toString())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidRoutingType((String)value);
        }
        return value;
    };
    public static final Validator<Integer> MAX_QUEUE_CONSUMERS = (name, value) -> {
        if (value < -1) {
            throw ActiveMQMessageBundle.BUNDLE.invalidMaxConsumers(name, (int)value);
        }
        return value;
    };
    public static final Validator<String> KEY_TYPE = (name, value) -> {
        if (value == null || !EnumSet.allOf(KeyType.class).contains((Object)KeyType.valueOf(value))) {
            throw ActiveMQMessageBundle.BUNDLE.invalidConnectionRouterKey((String)value);
        }
        return value;
    };
    public static final Validator<String> NULL_OR_TWO_CHARACTERS = (name, value) -> {
        if (value != null && value.length() != 2) {
            throw ActiveMQMessageBundle.BUNDLE.wrongLength(name, (String)value, value.length(), 2);
        }
        return value;
    };

    public static interface Validator<T> {
        public T validate(String var1, T var2);
    }
}

