/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.util.regex.Pattern;
import org.apache.mina.core.buffer.matcher.ClassNameMatcher;
import org.apache.mina.core.buffer.matcher.RegexpClassNameMatcher;
import org.apache.mina.core.buffer.matcher.WildcardClassNameMatcher;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;

public class ObjectSerializationCodecFactory
implements ProtocolCodecFactory {
    private final ObjectSerializationEncoder encoder = new ObjectSerializationEncoder();
    private final ObjectSerializationDecoder decoder;

    public ObjectSerializationCodecFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ObjectSerializationCodecFactory(ClassLoader classLoader) {
        this.decoder = new ObjectSerializationDecoder(classLoader);
    }

    @Override
    public ProtocolEncoder getEncoder(IoSession session) {
        return this.encoder;
    }

    @Override
    public ProtocolDecoder getDecoder(IoSession session) {
        return this.decoder;
    }

    public int getEncoderMaxObjectSize() {
        return this.encoder.getMaxObjectSize();
    }

    public void setEncoderMaxObjectSize(int maxObjectSize) {
        this.encoder.setMaxObjectSize(maxObjectSize);
    }

    public int getDecoderMaxObjectSize() {
        return this.decoder.getMaxObjectSize();
    }

    public void setDecoderMaxObjectSize(int maxObjectSize) {
        this.decoder.setMaxObjectSize(maxObjectSize);
    }

    public void accept(ClassNameMatcher classNameMatcher) {
        this.decoder.accept(classNameMatcher);
    }

    public void accept(Pattern pattern) {
        this.decoder.accept(new RegexpClassNameMatcher(pattern));
    }

    public void accept(String ... patterns) {
        for (String pattern : patterns) {
            this.decoder.accept(new WildcardClassNameMatcher(pattern));
        }
    }
}

