/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;

public class AnyMatchPredicate<T>
implements Predicate<Iterable<T>> {
    @Nonnull
    private final java.util.function.Predicate<T> predicate;

    public AnyMatchPredicate(@Nonnull java.util.function.Predicate<T> target) {
        this.predicate = Constraint.isNotNull(target, "Target predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable Iterable<T> inputs) {
        if (inputs == null) {
            return false;
        }
        for (T input : inputs) {
            if (!this.predicate.test(input)) continue;
            return true;
        }
        return false;
    }
}

