/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.server.routing.policies.ConsistentHashPolicy;
import org.apache.activemq.artemis.core.server.routing.targets.Target;

public class ConsistentHashModuloPolicy
extends ConsistentHashPolicy {
    public static final String NAME = "CONSISTENT_HASH_MODULO";
    public static final String MODULO = "MODULO";
    int modulo = 0;

    public ConsistentHashModuloPolicy() {
        super(NAME);
    }

    @Override
    public void init(Map<String, String> properties) {
        super.init(properties);
        this.modulo = Integer.parseInt(properties.get(MODULO));
    }

    @Override
    public String transformKey(String key) {
        if (this.modulo > 0) {
            return String.valueOf((this.getHash(key) & Integer.MAX_VALUE) % this.modulo);
        }
        return key;
    }

    @Override
    public Target selectTarget(List<Target> targets, String key) {
        return null;
    }
}

