/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InvalidAllocationTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkInvalidCapacity() throws Exception {
        block8: {
            WritableMemory wmem = WritableMemory.allocate((int)0);
            Assert.assertEquals((long)wmem.getCapacity(), (long)0L);
            Memory.wrap((byte[])new byte[0]);
            Memory.wrap((ByteBuffer)ByteBuffer.allocate(0));
            Memory mem3 = Memory.wrap((ByteBuffer)ByteBuffer.allocateDirect(0));
            mem3.region(0L, 0L);
            WritableMemory nullMem = null;
            try (Arena arena = Arena.ofConfined();){
                nullMem = WritableMemory.allocateDirect((long)-1L, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
                Assert.fail();
            }
            catch (IllegalArgumentException ignore) {
                if (nullMem == null) break block8;
                nullMem.getArena().close();
            }
        }
    }

    @Test
    public void checkInvalidAlignment() throws Exception {
        block8: {
            WritableMemory wmem = WritableMemory.allocate((int)0);
            Assert.assertEquals((long)wmem.getCapacity(), (long)0L);
            Memory.wrap((byte[])new byte[0]);
            Memory.wrap((ByteBuffer)ByteBuffer.allocate(0));
            Memory mem3 = Memory.wrap((ByteBuffer)ByteBuffer.allocateDirect(0));
            mem3.region(0L, 0L);
            WritableMemory nullMem = null;
            try (Arena arena = Arena.ofConfined();){
                nullMem = WritableMemory.allocateDirect((long)0L, (long)3L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
                Assert.fail();
            }
            catch (IllegalArgumentException ignore) {
                if (nullMem == null) break block8;
                nullMem.getArena().close();
            }
        }
    }

    @Test
    public void printlnTest() {
    }

    static void println(String s) {
    }
}

