/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.util.Arrays;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchToQuantilesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToQuantilesSketchTest {
    static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void nullInput() throws Exception {
        ArrayOfDoublesSketchToQuantilesSketch func = new ArrayOfDoublesSketchToQuantilesSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        ArrayOfDoublesSketchToQuantilesSketch func = new ArrayOfDoublesSketchToQuantilesSketch();
        DataByteArray result = (DataByteArray)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputSketch() throws Exception {
        ArrayOfDoublesSketchToQuantilesSketch func = new ArrayOfDoublesSketchToQuantilesSketch();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray())));
        Assert.assertNotNull((Object)result);
        DoublesSketch quantilesSketch = DoublesSketch.wrap((Memory)Memory.wrap((byte[])result.get()));
        Assert.assertTrue((boolean)quantilesSketch.isEmpty());
    }

    @Test
    public void nonEmptyInputSketchWithTwoColumnsExplicitK() throws Exception {
        int k = 256;
        ArrayOfDoublesSketchToQuantilesSketch func = new ArrayOfDoublesSketchToQuantilesSketch(Integer.toString(k));
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch.update(1L, new double[]{1.0, 2.0});
        sketch.update(2L, new double[]{10.0, 20.0});
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.compact().toByteArray()), 2)));
        Assert.assertNotNull((Object)result);
        DoublesSketch quantilesSketch = DoublesSketch.wrap((Memory)Memory.wrap((byte[])result.get()));
        Assert.assertFalse((boolean)quantilesSketch.isEmpty());
        Assert.assertEquals((int)quantilesSketch.getK(), (int)k);
        Assert.assertEquals((double)quantilesSketch.getMinValue(), (double)2.0);
        Assert.assertEquals((double)quantilesSketch.getMaxValue(), (double)20.0);
    }
}

