/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.util.Random;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.pig.tuple.UnionArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionArrayOfDoublesSketchTest {
    @Test
    public void execNullInput() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch("32", "1");
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch("32", "1");
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void exec() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch("4096", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)2.0, (double)0.0);
        }
    }

    @Test
    public void accumulatorNullInput() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(null);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyInputTuple() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(TupleFactory.getInstance().newTuple());
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorNotABag() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(PigUtil.objectsToTuple(new Object[]{null}));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyBag() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag()));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyInnerTuple() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(TupleFactory.getInstance().newTuple())));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorNullSketch() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch();
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple(new Object[]{null}))));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptySketch() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch("1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulator() throws Exception {
        UnionArrayOfDoublesSketch func = new UnionArrayOfDoublesSketch("4096", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        bag = BagFactory.getInstance().newDefaultBag();
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)2.0, (double)0.0);
        }
    }

    @Test
    public void algebraicInitial() throws Exception {
        UnionArrayOfDoublesSketch.Initial func = new UnionArrayOfDoublesSketch.Initial(null);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(null);
        bag.add(null);
        bag.add(null);
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicIntemediateFinalExact() throws Exception {
        UnionArrayOfDoublesSketch.IntermediateFinal func = new UnionArrayOfDoublesSketch.IntermediateFinal("1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)2.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalEstimation() throws Exception {
        UnionArrayOfDoublesSketch.IntermediateFinal func = new UnionArrayOfDoublesSketch.IntermediateFinal("16384", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long value = 1L;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (int i = 0; i < 20000; ++i) {
            sketch.update(value++, new double[]{1.0});
        }
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (int i = 0; i < 20000; ++i) {
            sketch.update(value++, new double[]{1.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)40000.0, (double)400.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)1.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalSingleCall() throws Exception {
        UnionArrayOfDoublesSketch.IntermediateFinal func = new UnionArrayOfDoublesSketch.IntermediateFinal("1024", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long value = 1L;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 10000; ++i) {
            sketch.update(value++, new double[]{1.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)10000.0, (double)200.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)1.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalRandomized() throws Exception {
        int i;
        UnionArrayOfDoublesSketch.IntermediateFinal func = new UnionArrayOfDoublesSketch.IntermediateFinal("16384", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long key = 1L;
        Random rnd = new Random();
        long uniques = 0L;
        long updates = 0L;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        key -= 20000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        key -= 20000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        key -= 20000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        key -= 20000L;
        sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, new double[]{rnd.nextDouble() * 20.0});
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)uniques, (double)((double)uniques * 0.01));
        double sum = 0.0;
        for (double[] values : sketch2.getValues()) {
            sum += values[0];
        }
        Assert.assertEquals((double)(sum / sketch2.getTheta()), (double)((double)updates * 10.0), (double)((double)updates * 10.0 * 0.02));
    }
}

