/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BootAllTest
extends BaseJDBCTestCase {
    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("BootAllTest");
        if (JDBC.vmSupportsJDBC3()) {
            BaseTestSuite db3 = new BaseTestSuite("db3");
            db3.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db3.addTest((Test)new BootAllTest("shutdownDerby"));
            Properties ba = new Properties();
            ba.setProperty("derby.system.bootAll", "true");
            db3.addTest((Test)new SystemPropertyTestSetup((Test)new BootAllTest("testSettingBootAllPropertyWithHomePropertySet"), ba));
            BaseTestSuite db2 = new BaseTestSuite("db2");
            db2.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db2.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db3));
            BaseTestSuite db1 = new BaseTestSuite("db1");
            db1.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db1.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db2));
            suite.addTest((Test)new BootAllTest("createShutdownDatabase"));
            suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db1));
        }
        return suite;
    }

    public BootAllTest(String name) {
        super(name);
    }

    public void createShutdownDatabase() throws SQLException {
        this.getConnection().close();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void shutdownDerby() {
        this.getTestConfiguration().shutdownEngine();
        System.runFinalization();
        System.gc();
    }

    public void testSettingBootAllPropertyWithHomePropertySet() throws Exception {
        JDBCClient embedded = this.getTestConfiguration().getJDBCClient();
        String driverName = embedded.getJDBCDriverName();
        String url = embedded.getUrlBase();
        try {
            DriverManager.getDriver(url);
            BootAllTest.fail((String)"Derby is booted!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Class<?> clazz = Class.forName(driverName);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Driver driver = DriverManager.getDriver(url);
        DriverPropertyInfo[] attributes = driver.getPropertyInfo(url, null);
        String[] returnedDatabases = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].name.equalsIgnoreCase("databaseName")) continue;
            returnedDatabases = attributes[i].choices;
        }
        BootAllTest.assertNotNull(returnedDatabases);
        BootAllTest.assertTrue((String)"Fewer databases booted than expected", (returnedDatabases.length >= 1 ? 1 : 0) != 0);
    }
}

