/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class StaticClassFieldReferenceNode
extends JavaValueNode {
    private String fieldName;
    private String javaClassName;
    private boolean classNameDelimitedIdentifier;
    private Member field;

    StaticClassFieldReferenceNode(String javaClassName, String fieldName, boolean classNameDelimitedIdentifier, ContextManager cm) {
        super(cm);
        this.fieldName = fieldName;
        this.javaClassName = javaClassName;
        this.classNameDelimitedIdentifier = classNameDelimitedIdentifier;
    }

    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if ((this.getCompilerContext().getReliability() & 0x400) != 0 || !this.javaClassName.startsWith("java.sql.")) {
            throw StandardException.newException("42X01", this.javaClassName + "::" + this.fieldName);
        }
        this.verifyClassExist(this.javaClassName);
        this.field = classInspector.findPublicField(this.javaClassName, this.fieldName, true);
        this.setJavaTypeName(classInspector.getType(this.field));
        return this;
    }

    @Override
    void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) {
        return true;
    }

    @Override
    JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    @Override
    int getOrderableVariantType() {
        SanityManager.ASSERT(this.field != null, "field is expected to be non-null");
        if (Modifier.isFinal(this.field.getModifiers())) {
            return 3;
        }
        return 0;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.getStaticField(this.field.getDeclaringClass().getName(), this.fieldName, this.getJavaTypeName());
    }
}

