/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ForeignKeyRIChecker
extends GenericRIChecker {
    ForeignKeyRIChecker(LanguageConnectionContext lcc, TransactionController tc, FKInfo fkinfo) throws StandardException {
        super(lcc, tc, fkinfo);
        if (this.fkInfo.type != 1) {
            SanityManager.THROWASSERT("invalid type " + this.fkInfo.type + " for a ForeignKeyRIChecker");
        }
    }

    @Override
    void doCheck(Activation a, ExecRow row, boolean restrictCheckOnly, int deferredRowReq) throws StandardException {
        if (restrictCheckOnly) {
            return;
        }
        if (this.isAnyFieldNull(row)) {
            return;
        }
        ScanController scan = this.getScanController(this.fkInfo.refConglomNumber, this.refScoci, this.refDcoci, row);
        if (!scan.next()) {
            UUID fkId = this.fkInfo.fkIds[0];
            this.close();
            if (this.fkInfo.deferrable[0] && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(a), fkId)) {
                this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.fkInfo.fkIds[0], this.indexQualifierRow.getRowArray(), this.fkInfo.schemaName, this.fkInfo.tableName);
            } else {
                StandardException se = StandardException.newException("23503", this.fkInfo.fkConstraintNames[0], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(row, this.fkInfo.colArray));
                throw se;
            }
        }
    }

    @Override
    int getRICheckIsolationLevel() {
        return 2;
    }
}

