/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTruncateTest
extends BaseJDBCTestCase {
    public ClobTruncateTest(String string) {
        super(string);
    }

    private void insertClobs() throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement = this.prepareStatement("insert into truncateclob values (?,?,?)");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 100; ++n) {
            stringBuffer.append("small clob");
        }
        n = stringBuffer.length();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, (Reader)new StringReader(stringBuffer.toString()), n);
        preparedStatement.setInt(3, n / 2);
        preparedStatement.execute();
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(0x100000L);
        preparedStatement.setInt(1, 0x100000);
        preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, 0x100000);
        preparedStatement.setInt(3, 524288);
        preparedStatement.execute();
        LoopingAlphabetReader loopingAlphabetReader2 = new LoopingAlphabetReader(300000L, CharAlphabet.tamil());
        preparedStatement.setInt(1, 300000);
        preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader2, 300000);
        preparedStatement.setInt(3, 150000);
        preparedStatement.execute();
    }

    private void checkTruncate(int n, Clob clob, int n2) throws SQLException {
        ClobTruncateTest.assertEquals((String)"unexpected clob size", (long)n, (long)clob.length());
        clob.truncate(n2);
        ClobTruncateTest.assertEquals((String)"truncate failed ", (long)n2, (long)clob.length());
        clob.truncate(n2 / 2);
        ClobTruncateTest.assertEquals((String)"truncate failed ", (long)(n2 / 2), (long)clob.length());
    }

    public void testTruncateOnClob() throws SQLException, IOException {
        this.insertClobs();
        this.getConnection().setAutoCommit(false);
        ResultSet resultSet = this.createStatement().executeQuery("select size, data, newsize from truncateclob");
        try {
            while (resultSet.next()) {
                this.checkTruncate(resultSet.getInt(1), resultSet.getClob(2), resultSet.getInt(3));
            }
        }
        finally {
            resultSet.close();
            this.getConnection().commit();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table truncateclob");
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement statement = this.createStatement();
        statement.executeUpdate("create table truncateclob (size integer, data clob, newSize integer)");
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ClobTruncateTest.class);
    }
}

