/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IntArray
implements Externalizable,
Comparable {
    private int[] _data;

    public IntArray() {
    }

    public IntArray(int[] nArray) {
        this._data = nArray;
    }

    public static IntArray makeIntArray(int ... nArray) {
        return new IntArray(nArray);
    }

    public static IntArray makeIntArray(int n) {
        return new IntArray(new int[n]);
    }

    public static IntArray setCell(IntArray intArray, int n, int n2) {
        intArray._data[n] = n2;
        return intArray;
    }

    public static int getCell(IntArray intArray, int n) {
        return intArray._data[n];
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this._data.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeInt(this._data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this._data = new int[n];
        for (int i = 0; i < n; ++i) {
            this._data[i] = objectInput.readInt();
        }
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            return -1;
        }
        if (!(object instanceof IntArray)) {
            return -1;
        }
        IntArray intArray = (IntArray)object;
        int n2 = this._data.length <= intArray._data.length ? this._data.length : intArray._data.length;
        for (int i = 0; i < n2; ++i) {
            n = this._data[i] - intArray._data[i];
            if (n == 0) continue;
            return n;
        }
        n = this._data.length - intArray._data.length;
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n;
        int n2;
        if (this._data.length == 0) {
            n2 = 1;
            n = 1;
        } else {
            n2 = this._data[0];
            n = this._data[this._data.length - 1];
        }
        return n2 ^ n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._data.length;
        stringBuffer.append("[ ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._data[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

