/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SubqueryFlatteningTest
extends BaseJDBCTestCase {
    public SubqueryFlatteningTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(SubqueryFlatteningTest.class);
    }

    protected void setUp() throws SQLException {
        this.setAutoCommit(false);
    }

    private void enableRuntimeStatistics(Statement statement) throws SQLException {
        statement.execute("call syscs_util.syscs_set_runtimestatistics(1)");
    }

    private void checkExistsJoin(Statement statement, String string, String[][] stringArray, boolean bl) throws SQLException {
        JDBC.assertFullResultSet(statement.executeQuery(string), stringArray);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SubqueryFlatteningTest.assertEquals((String)"unexpected plan", (boolean)bl, (boolean)runtimeStatisticsParser.usedExistsJoin());
    }

    public void testNotExistsFlattenablePredicatesNotPulled() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t (x int not null)");
        statement.execute("insert into t values 1,2,3");
        this.enableRuntimeStatistics(statement);
        String[][] stringArray = new String[][]{{"1"}, {"2"}, {"3"}};
        this.checkExistsJoin(statement, "select * from t where not exists (select x from t where 1<>1)", stringArray, true);
        this.checkExistsJoin(statement, "select * from t where x not in (select x from t where 1<>1)", stringArray, true);
        this.checkExistsJoin(statement, "select * from t where x < all (select x from t where 1<>1)", stringArray, true);
    }

    public void testAllNotFlattenableToNotExists() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t (x int not null)");
        statement.execute("insert into t values 1,2,3");
        this.enableRuntimeStatistics(statement);
        String[][] stringArray = new String[][]{{"1"}, {"2"}, {"3"}};
        this.checkExistsJoin(statement, "select * from t where x < all (select 100 from t)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t where 1 < all (select 2 from t)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t where x = all (select 1 from t)", new String[][]{{"1"}}, false);
        this.checkExistsJoin(statement, "select * from t t1 where x < all (select x from t t2 where t1.x > 100)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t t1 where x < all (select x from t t2 where t1.x > 100 and t2.x > 100)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t t1 where x < all (select x from t t2 where t1.x > 100 or t2.x > 100)", stringArray, true);
    }

    public void testNotInNotFlattenableToNotExists() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t (x int not null)");
        statement.execute("insert into t values 1,2,3");
        this.enableRuntimeStatistics(statement);
        String[][] stringArray = new String[][]{{"1"}, {"2"}, {"3"}};
        this.checkExistsJoin(statement, "select * from t where x not in (select 100 from t)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t where 1 not in (select 100 from t)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t where x not in (select 2 from t)", new String[][]{{"1"}, {"3"}}, false);
        this.checkExistsJoin(statement, "select * from t t1 where x not in (select x from t t2 where t1.x > 100)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t t1 where x not in (select x from t t2 where t1.x > 100 and t2.x > 100)", stringArray, false);
        this.checkExistsJoin(statement, "select * from t t1 where x not in (select x from t t2 where t1.x > 100 or t2.x > 100)", stringArray, true);
    }
}

