/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class UpdateCursorTest
extends BaseJDBCTestCase {
    private static final int SIZE_OF_T1 = 250;
    private static final String EXPECTED_SQL_CODE = "02000";

    public UpdateCursorTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.language.maxMemoryPerTable", "1");
        return new DatabasePropertyTestSetup((Test)new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup((Test)new BaseTestSuite(UpdateCursorTest.class, "UpdateCursorTest")){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                StringBuffer stringBuffer = new StringBuffer(1000);
                BaseJDBCTestCase.assertUpdateCount(statement, 0, "create table T1 (  c1\tint,  c2\tchar(50),  c3\tint,  c4   char(50),  c5   int,  c6   varchar(1000))");
                BaseJDBCTestCase.assertUpdateCount(statement, 0, "create index I11 on T1(c3, c1, c5)");
                BaseJDBCTestCase.assertUpdateCount(statement, 0, "create table T2(  c1 \tint)");
                BaseJDBCTestCase.assertUpdateCount(statement, 0, "create table T3(  c1\tchar(20) not null primary key)");
                BaseJDBCTestCase.assertUpdateCount(statement, 0, "create table T4(  c1 \tchar(20) references T3(c1) on delete cascade)");
                for (n = 0; n < 1000; ++n) {
                    stringBuffer.append('a');
                }
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into T1 values (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?)");
                String string = new String(stringBuffer);
                for (n = 246; n > 0; n -= 5) {
                    int n2 = 0;
                    for (int i = 0; i < 5; ++i) {
                        preparedStatement.setInt(1 + n2, n + (4 - i));
                        preparedStatement.setString(2 + n2, Integer.toString(n));
                        preparedStatement.setInt(3 + n2, n + i);
                        preparedStatement.setString(4 + n2, Integer.toString(n));
                        preparedStatement.setInt(5 + n2, n);
                        preparedStatement.setString(6 + n2, string);
                        n2 += 6;
                    }
                    BaseJDBCTestCase.assertUpdateCount(preparedStatement, 5);
                }
                statement.executeUpdate("insert into t2 values (1)");
                preparedStatement.close();
            }
        }, properties), properties, true);
    }

    public void testVirtualMemoryHeap() throws SQLException {
        int n;
        PreparedStatement preparedStatement = this.prepareStatement("select c1, c3 from t1 where c3 > 1 and c1 > 0 for update");
        Statement statement = this.createStatement();
        int n2 = 1;
        UpdateCursorTest.assertUpdateCount(statement, 0, "drop index I11");
        UpdateCursorTest.assertUpdateCount(statement, 0, "create index I11 on T1 (c3, c1, c5)");
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = resultSet.getCursorName();
        for (n = 0; n < 249; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
            UpdateCursorTest.assertEquals((String)"Virtual memory heap test failed! Got unexpected value.", (int)(++n2), (int)resultSet.getInt(2));
            statement.execute("update t1 set c3 = c3 + 250 where current of " + string);
        }
        UpdateCursorTest.assertFalse((String)"Update with virtual memory heap failed! Still got rows.", (boolean)resultSet.next());
        resultSet.close();
        statement.close();
        preparedStatement = this.prepareStatement("select c1, c3 from t1");
        resultSet = preparedStatement.executeQuery();
        for (n = 0; n < 250; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update with virtual memory heeap failed! Got more rows.", (boolean)resultSet.next());
        preparedStatement.close();
        resultSet.close();
        this.rollback();
    }

    public void testNonCoveringIndex() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("select c3, c2 from t1 where c3 > 125 and c1 > 0 for update");
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = resultSet.getCursorName();
        for (n = 0; n < 125; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
            statement.execute("update t1 set c3 = c3 + 25 where current of " + string);
        }
        UpdateCursorTest.assertFalse((String)"Update using noncovering index failed! Still got rows.", (boolean)resultSet.next());
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select c1, c3 from t1");
        resultSet = preparedStatement.executeQuery();
        for (n = 0; n < 250; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update using noncovering index failed! Got more rows.", (boolean)resultSet.next());
        preparedStatement.close();
        resultSet.close();
        this.rollback();
    }

    public void testDescendingIndex() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        UpdateCursorTest.assertUpdateCount(statement, 0, "drop index I11");
        UpdateCursorTest.assertUpdateCount(statement, 0, "create index I11 on T1 (c3 desc, c1, c5 desc)");
        this.commit();
        statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("select c3, c1 from t1 where c3 > 125 and c1 > 0 for update");
        ResultSet resultSet = preparedStatement.executeQuery();
        for (n = 0; n < 125; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
            if (n % 2 == 0) {
                statement.execute("update t1 set c3 = c3 + 1 where current of " + resultSet.getCursorName());
                continue;
            }
            statement.execute("update t1 set c3 = c3 - 1 where current of " + resultSet.getCursorName());
        }
        UpdateCursorTest.assertFalse((String)"Update using desc index failed! Got more rows.", (boolean)resultSet.next());
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select c3, c2 from t1");
        resultSet = preparedStatement.executeQuery();
        for (n = 0; n < 250; ++n) {
            UpdateCursorTest.assertEquals((boolean)resultSet.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update using desc index failed! Got more rows.", (boolean)resultSet.next());
        preparedStatement.close();
        resultSet.close();
        this.rollback();
    }

    public void testUpdateDeleteWarning() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("update t2 set c1 = 2 where c1 = 1");
        SQLWarning sQLWarning = statement.getWarnings();
        UpdateCursorTest.assertNull((String)"The update should not return a warning.", (Object)sQLWarning);
        statement.executeUpdate("update t2 set c1 = 2 where c1 = 1");
        sQLWarning = statement.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The update should return a warning.", (Object)sQLWarning);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sQLWarning.getSQLState());
        statement.executeUpdate("delete from t2 where c1 = 2");
        sQLWarning = statement.getWarnings();
        UpdateCursorTest.assertNull((String)"The delete should not return a warning.", (Object)sQLWarning);
        statement.executeUpdate("delete from t2 where c1 = 2");
        sQLWarning = statement.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The delete should return a warning.", (Object)sQLWarning);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sQLWarning.getSQLState());
        statement.executeUpdate("delete from t3");
        sQLWarning = statement.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The delete cascade should return a warning.", (Object)sQLWarning);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sQLWarning.getSQLState());
        statement.close();
        this.rollback();
    }

    public void testDerby5425HoldOverCommit() throws SQLException {
        Statement statement = this.createStatement();
        UpdateCursorTest.assertUpdateCount(statement, 0, "drop index I11");
        UpdateCursorTest.assertUpdateCount(statement, 0, "create index I11 on T1 (c3, c1, c5)");
        PreparedStatement preparedStatement = this.prepareStatement("select c3 from t1 --DERBY-PROPERTIES index=I11", 1003, 1008);
        ResultSet resultSet = preparedStatement.executeQuery();
        for (int i = 1; i <= 250; ++i) {
            UpdateCursorTest.assertTrue((String)"Too few rows", (boolean)resultSet.next());
            UpdateCursorTest.assertEquals((int)i, (int)resultSet.getInt(1));
            resultSet.updateInt(1, i);
            resultSet.updateRow();
            this.commit();
        }
        UpdateCursorTest.assertFalse((String)"Too many rows", (boolean)resultSet.next());
        resultSet.close();
    }
}

