/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Random;
import junit.framework.Test;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derbyTesting.functionTests.tests.memorydb.MemoryDbManager;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class DropWhileConnectingTest
extends BaseJDBCTestCase {
    public DropWhileConnectingTest(String string) {
        super(string);
    }

    public void testConcurrentAccessAndDrop() throws SQLException {
        Connection connection = MemoryDbManager.getSharedInstance().createDatabase("testDB");
        connection.close();
        String string = DropWhileConnectingTest.getSystemProperty("derby.tests.threadCount");
        if (string == null) {
            string = "20";
        }
        int n = Integer.parseInt(string);
        DropWhileConnectingTest.println("threadCount=" + n);
        Report report = new Report(this.getFailureFolder(), n);
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(new AccessThread(report, "jdbc:derby:memory:testDB"));
            thread.start();
        }
        report.start();
        DropWhileConnectingTest.sleep(2500L);
        try {
            MemoryDbManager.getSharedInstance().dropDatabase("testDB");
            DropWhileConnectingTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            DropWhileConnectingTest.assertSQLState("08006", sQLException);
        }
        DropWhileConnectingTest.println("Drop database request executed.");
        while (!report.allThreadsDone()) {
            DropWhileConnectingTest.println("Waiting for " + report.remainingThreads() + " remaining thread(s) to finish...");
            DropWhileConnectingTest.sleep(500L);
        }
        DropWhileConnectingTest.assertFalse((String)report.toString(), (boolean)report.hasUnexpectedExceptions());
        DropWhileConnectingTest.println(report.toString());
    }

    public static Test suite() {
        return new BaseTestSuite(DropWhileConnectingTest.class);
    }

    private static class AccessThread
    implements Runnable {
        private static final Object LOCK = new Object();
        private static int idCounter = 0;
        private static final boolean noWait;
        private final int id;
        private final Report master;
        private final String url;
        private final Random rnd = new Random();
        private boolean waited;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccessThread(Report report, String string) {
            Object object = LOCK;
            synchronized (object) {
                this.id = idCounter++;
            }
            this.master = report;
            this.url = string + ";user=test;password=test";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            int n = 0;
            Connection connection = null;
            while (!this.master.ready()) {
                object = this.master.getSync();
                synchronized (object) {
                    try {
                        this.master.getSync().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                while (true) {
                    this.waited = false;
                    try {
                        connection = DriverManager.getConnection(this.url);
                        ++n;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getSQLState().equals("XJ004")) {
                            this.master.reportAccessCount(this.id, n);
                            break;
                        }
                        if (sQLException.getSQLState().equals("XJ005")) {
                            this.allowWait(false);
                            continue;
                        }
                        throw sQLException;
                    }
                    try {
                        object = connection.createStatement();
                        this.allowWait(true);
                        ResultSet resultSet = object.executeQuery("select * from sys.systables order by random()");
                        this.allowWait(true);
                        while (resultSet.next()) {
                            this.allowWait(true);
                            resultSet.getString(1);
                        }
                        resultSet.close();
                        object.close();
                        connection.close();
                        this.allowWait(false);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getSQLState().equals("08003")) {
                            this.master.reportAccessCount(this.id, n);
                            continue;
                        }
                        if (sQLException.getSQLState().equals("XJ001") && sQLException.getMessage().indexOf("ShutdownException") != -1) {
                            this.master.reportAccessCount(this.id, n);
                            continue;
                        }
                        this.master.reportError(this.id, n, sQLException);
                    }
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof ShutdownException) {
                    System.out.println("Got ShutdownException (extends RuntimeException)");
                    this.master.reportAccessCount(this.id, n);
                }
                this.master.reportError(this.id, n, throwable);
            }
        }

        private void allowWait(boolean bl) {
            if (!noWait && (!this.waited && bl || !bl)) {
                int n = this.rnd.nextInt(100);
                if (n >= 97) {
                    BaseTestCase.sleep(100L + (long)(this.rnd.nextDouble() * 1200.0));
                    this.waited = true;
                } else if (n > 80) {
                    BaseTestCase.sleep((long)(this.rnd.nextDouble() * 100.0));
                    this.waited = true;
                }
            }
        }

        static {
            String string = DropWhileConnectingTest.getSystemProperty("derby.tests.noWait");
            noWait = Boolean.valueOf(string);
            BaseTestCase.println("noWait=" + noWait);
        }
    }

    private static class Report {
        private final Object sync = new Object();
        private boolean ready;
        private final File failureFolder;
        private PrintWriter writer;
        private final int[] accessCounts;
        private final Throwable[] exceptions;
        private int threadsDone;
        private boolean hasExceptions;

        public Report(File file, int n) {
            this.failureFolder = file;
            this.accessCounts = new int[n];
            this.exceptions = new Throwable[n];
        }

        public synchronized boolean hasUnexpectedExceptions() {
            return this.hasExceptions;
        }

        public synchronized void reportAccessCount(int n, int n2) {
            this.accessCounts[n] = n2;
            ++this.threadsDone;
        }

        public synchronized void reportError(int n, int n2, Throwable throwable) {
            this.reportAccessCount(n, n2);
            this.exceptions[n] = throwable;
            this.hasExceptions = true;
            this.dumpToFile(n, throwable);
        }

        public synchronized boolean allThreadsDone() {
            return this.threadsDone == this.accessCounts.length;
        }

        public synchronized int remainingThreads() {
            return this.accessCounts.length - this.threadsDone;
        }

        public Object getSync() {
            return this.sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() {
            Object object = this.sync;
            synchronized (object) {
                return this.ready;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.sync;
            synchronized (object) {
                this.ready = true;
                this.sync.notifyAll();
            }
        }

        public synchronized String toString() {
            int n = 0;
            for (int i = 0; i < this.accessCounts.length; ++i) {
                int n2 = this.accessCounts[i];
                if (n2 <= 0) continue;
                n += n2;
            }
            String string = "\n";
            StringBuffer stringBuffer = new StringBuffer(string + "Number of access threads: ").append(this.accessCounts.length).append(string);
            stringBuffer.append("Access count: " + n).append(string);
            if (this.hasExceptions) {
                stringBuffer.append("Exceptions (see " + this.failureFolder + "/exceptions.log):" + string);
                for (int i = 0; i < this.exceptions.length; ++i) {
                    Throwable throwable = this.exceptions[i];
                    if (throwable instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable;
                        stringBuffer.append("id=").append(i).append(" : (").append(sQLException.getSQLState()).append(") ").append(sQLException.getMessage()).append(string);
                        continue;
                    }
                    if (throwable == null) continue;
                    stringBuffer.append("id=").append(i).append(" : (     ) ").append(throwable.getMessage()).append(string);
                }
            }
            return stringBuffer.toString();
        }

        private void dumpToFile(int n, Throwable throwable) {
            if (this.writer == null) {
                try {
                    this.writer = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(this.failureFolder, "exceptions.log")));
                    this.writer.println(new Date());
                }
                catch (IOException iOException) {
                    BaseTestCase.alarm("Failed to create exception log file: " + iOException.getMessage());
                }
            }
            if (this.writer != null) {
                this.writer.println("-----");
                this.writer.println("id=" + n);
                this.writer.println("--");
                throwable.printStackTrace(this.writer);
                this.writer.flush();
            }
        }
    }
}

