/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_3_p2
extends ReplicationRun_Local_3 {
    public ReplicationRun_Local_3_p2(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_3_p2 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_3_p2.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void replication_Local_3_p2_StateTests(boolean bl, boolean bl2) throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        String string = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int n = bl ? 9876 : 10;
        this._testInsertUpdateDeleteOnMaster(masterServerHost, masterServerPort, string, n);
        if (!bl2) {
            this.util.DEBUG("sleep(10000L)");
            Thread.sleep(10000L);
        }
        this.assertException(this._stopMaster(masterServerHost, masterServerPort, string), null);
        this.waitForConnect(100L, 200, string, masterServerHost, masterServerPort);
        String string2 = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        if (!bl && bl2) {
            this.waitForSQLState("08004", 100L, 200, string2, slaveServerHost, slaveServerPort);
        } else {
            this.waitForConnect(100L, 200, string2, slaveServerHost, slaveServerPort);
            this._verifyDatabase(slaveServerHost, slaveServerPort, string2, n);
        }
        String string3 = "XRE07";
        if (!bl && bl2) {
            string3 = null;
        }
        this.assertException(this._failOver(slaveServerHost, slaveServerPort, string2), string3);
        this.waitForConnect(100L, 200, string2, slaveServerHost, slaveServerPort);
        this.connectPing(string2, slaveServerHost, slaveServerPort, testClientHost);
        this._verifyDatabase(slaveServerHost, slaveServerPort, string2, n);
        this._verifyDatabase(masterServerHost, masterServerPort, string, n);
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    public void testReplication_Local_3_p2_StateTests_bigInsert_immediateStopMaster() throws Exception {
        this.replication_Local_3_p2_StateTests(true, true);
    }

    public void testReplication_Local_3_p2_StateTests_bigInsert_sleepBeforeStopMaster() throws Exception {
        this.replication_Local_3_p2_StateTests(true, false);
    }

    public void testReplication_Local_3_p2_StateTests_smallInsert_sleepBeforeStopMaster() throws Exception {
        this.replication_Local_3_p2_StateTests(false, false);
    }
}

