/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class XML {
    private static final boolean HAVE_JAXP = JDBC.haveClass("org.w3c.dom.Document");
    private static final boolean HAVE_JAXP_IMPL = HAVE_JAXP && XML.checkJAXPImplementation();
    private static final boolean HAVE_XPATH = HAVE_JAXP_IMPL && XML.checkXPathSupport();
    private static final String HELPER_FILE_LOCATION = "org/apache/derbyTesting/functionTests/tests/lang/xmlTestFiles/";

    public static boolean classpathHasJAXP() {
        return HAVE_JAXP_IMPL;
    }

    public static boolean classpathMeetsXMLReqs() {
        return HAVE_XPATH;
    }

    public static void insertFile(Connection connection, String string, String string2, String object, int n) throws IOException, SQLException, PrivilegedActionException {
        object = HELPER_FILE_LOCATION + (String)object;
        URL uRL = BaseTestCase.getTestResource((String)object);
        Assert.assertNotNull((String)("XML input file missing: " + (String)object), (Object)uRL);
        int n2 = 0;
        char[] cArray = new char[1024];
        InputStreamReader inputStreamReader = new InputStreamReader(BaseTestCase.openTestResource(uRL));
        int n3 = inputStreamReader.read(cArray, 0, cArray.length);
        while (n3 != -1) {
            n2 += n3;
            n3 = inputStreamReader.read(cArray, 0, cArray.length);
        }
        inputStreamReader.close();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string + "(" + string2 + ") values (xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < n; ++i) {
            inputStreamReader = new InputStreamReader(BaseTestCase.openTestResource(uRL));
            preparedStatement.setCharacterStream(1, (Reader)inputStreamReader, n2);
            preparedStatement.execute();
            inputStreamReader.close();
        }
        preparedStatement.close();
    }

    public static void insertDocWithDTD(Connection connection, String string, String string2, String object, String string3, int n) throws IOException, SQLException, PrivilegedActionException {
        object = HELPER_FILE_LOCATION + (String)object;
        URL uRL = BaseTestCase.getTestResource((String)object);
        Assert.assertNotNull((String)("XML input file missing: " + (String)object), (Object)uRL);
        int n2 = 0;
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = new InputStreamReader(BaseTestCase.openTestResource(uRL));
        int n3 = inputStreamReader.read(cArray, 0, cArray.length);
        while (n3 != -1) {
            stringBuffer.append(cArray, 0, n3);
            n2 += n3;
            n3 = inputStreamReader.read(cArray, 0, cArray.length);
        }
        inputStreamReader.close();
        URL uRL2 = SupportFilesSetup.getReadOnlyURL(string3);
        Assert.assertNotNull((String)("DTD file missing: " + string3), (Object)uRL2);
        String string4 = stringBuffer.toString();
        int n4 = string4.indexOf(string3);
        if (n4 != -1) {
            stringBuffer.replace(n4, n4 + string3.length(), uRL2.toExternalForm());
        }
        string4 = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string + "(" + string2 + ") values (xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setString(1, string4);
            preparedStatement.execute();
        }
        preparedStatement.close();
    }

    private static boolean checkXPathSupport() {
        try {
            Class<?> clazz = Class.forName("javax.xml.xpath.XPathFactory");
            Method method = clazz.getMethod("newInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return object != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean checkJAXPImplementation() {
        try {
            Class<?> clazz = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method method = clazz.getMethod("newInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return object != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected static String getJAXPParserLocation() {
        if (!XML.classpathHasJAXP()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("org.apache.derbyTesting.junit.JAXPFinder");
            Method method = clazz.getDeclaredMethod("getJAXPParserLocation", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }
}

