/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DRDAProtocolTest
extends BaseJDBCTestCase {
    private String threadName;

    public void setUp() {
        this.threadName = Thread.currentThread().getName();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread().setName(this.threadName);
    }

    public void testNonEBCDICCharacters() throws SQLException {
        Thread.currentThread().setName("\u4e10");
        Connection connection = this.openConnection("FIRSTDB1");
        connection.close();
    }

    public void testMultipleConnections() throws SQLException {
        Connection connection = this.openConnection("FIRSTDB1");
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("create table FIRSTDB_T1 (i int, j int, k int)");
        statement.execute("insert into FIRSTDB_T1 values (1, 3, 5)");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from FIRSTDB_T1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.close();
        preparedStatement.close();
        statement.close();
        Connection connection2 = this.openConnection("SECONDDB2");
        connection2.setAutoCommit(false);
        Statement statement2 = connection2.createStatement();
        statement2.execute("create table SECONDDB_T1 (i int, j int, k int)");
        statement2.execute("insert into SECONDDB_T1 values (2, 4, 6)");
        PreparedStatement preparedStatement2 = connection2.prepareStatement("select * from SECONDDB_T1");
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        resultSet.close();
        preparedStatement2.close();
        statement2.close();
        JDBC.cleanup(connection);
        JDBC.cleanup(connection2);
    }

    public DRDAProtocolTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.clientServerSuite(DRDAProtocolTest.class);
        object = TestConfiguration.additionalDatabaseDecorator(object, "FIRSTDB1");
        object = TestConfiguration.additionalDatabaseDecorator(object, "SECONDDB2");
        return object;
    }
}

