/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobStreamsTest
extends BaseJDBCTestCase {
    int[] streamSize = new int[2];
    private final String unicodeTestString = "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)";

    public LobStreamsTest(String string) {
        super(string);
        this.streamSize[0] = 300000;
        this.streamSize[1] = 10000;
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table testBlobX1 (a integer, b blob(300K), c clob(300K))");
        statement.close();
        byte[] byArray = new byte[]{64};
        String string = "c";
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testBlobX1(a, b, c) VALUES (?, ?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testGettingBlobTwice() throws Exception {
        this.setAutoCommit(false);
        int n = 72711;
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlobX1(a,b) values (?,?)");
        preparedStatement.setInt(1, 2);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(n), n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select b from testBlobX1 where a = ?");
        preparedStatement.setInt(1, 2);
        ResultSet resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((boolean)resultSet.next());
        Blob blob = resultSet.getBlob(1);
        try {
            LobStreamsTest.assertEquals((long)n, (long)resultSet.getBlob(1).length());
            LobStreamsTest.fail((String)"Getting the Blob the second time should have failed");
        }
        catch (SQLException sQLException) {
            LobStreamsTest.assertSQLState("XCL18", sQLException);
        }
        int n2 = 10240;
        byte[] byArray = null;
        for (int i = 0; i < 50; ++i) {
            byArray = new byte[n2 * (i + 1)];
        }
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        InputStream inputStream = blob.getBinaryStream();
        while (inputStream.read() != -1) {
        }
        LobStreamsTest.assertNotNull((Object)byArray);
    }

    public void testGettingClobTwice() throws SQLException {
        int n = 72711;
        PreparedStatement preparedStatement = this.prepareStatement("insert into testBlobX1(a,c) values (?,?)");
        preparedStatement.setInt(1, 3);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 4);
        preparedStatement.setString(2, "short clob");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        int n2 = 0;
        preparedStatement = this.prepareStatement("select c from testBlobX1 where a >= ? and a <= ?");
        preparedStatement.setInt(1, 3);
        preparedStatement.setInt(2, 4);
        ResultSet resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((boolean)resultSet.next());
        do {
            ++n2;
            Clob clob = resultSet.getClob(1);
            try {
                resultSet.getClob(1);
                LobStreamsTest.fail((String)"Getting the Clob the second time should have failed");
            }
            catch (SQLException sQLException) {
                LobStreamsTest.assertSQLState("XCL18", sQLException);
            }
            try {
                resultSet.getCharacterStream(1);
                LobStreamsTest.fail((String)"Getting the Clob the third time should have failed");
            }
            catch (SQLException sQLException) {
                LobStreamsTest.assertSQLState("XCL18", sQLException);
            }
        } while (resultSet.next());
        resultSet.close();
        LobStreamsTest.assertEquals((int)2, (int)n2);
    }

    public void testBlobWrite3Param() throws Exception {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(this.streamSize[0]);
        LobStreamsTest.assertTrue((String)"FAIL -- file not found", (loopingAlphabetStream != null ? 1 : 0) != 0);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT b FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- blob is NULL", (blob != null ? 1 : 0) != 0);
        int n = 0;
        byte[] byArray = new byte[1024];
        OutputStream outputStream = blob.setBinaryStream(1L);
        while ((n = loopingAlphabetStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        loopingAlphabetStream.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET b = ? WHERE a = 1");
        preparedStatement2.setBlob(1, blob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- blob not found", (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        long l = blob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong blob length;", (long)this.streamSize[0], (long)l);
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(this.streamSize[0]);
        InputStream inputStream = blob.getBinaryStream();
        LobStreamsTest.assertTrue((String)"FAIL - Blob and file contents do not match", (boolean)this.compareLob2File(loopingAlphabetStream2, inputStream));
        loopingAlphabetStream2.close();
        inputStream.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testBlobWrite1Param() throws Exception {
        int n;
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(this.streamSize[1]);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT b FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- blob is NULL", (blob != null ? 1 : 0) != 0);
        OutputStream outputStream = blob.setBinaryStream(1L);
        while ((n = ((InputStream)loopingAlphabetStream).read()) != -1) {
            outputStream.write(n);
        }
        outputStream.close();
        loopingAlphabetStream.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET b = ? WHERE a = 1");
        preparedStatement2.setBlob(1, blob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- blob not found", (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        long l = blob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong blob length", (long)this.streamSize[1], (long)l);
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(this.streamSize[1]);
        InputStream inputStream = blob.getBinaryStream();
        LobStreamsTest.assertTrue((String)"FAIL - Blob and file contents do not match", (boolean)this.compareLob2File(loopingAlphabetStream2, inputStream));
        loopingAlphabetStream2.close();
        inputStream.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobAsciiWrite1Param() throws Exception {
        int n;
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(this.streamSize[1]);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        OutputStream outputStream = clob.setAsciiStream(1L);
        while ((n = ((InputStream)loopingAlphabetStream).read()) != -1) {
            outputStream.write(n);
        }
        outputStream.close();
        loopingAlphabetStream.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)this.streamSize[1], (long)l);
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(this.streamSize[1]);
        InputStream inputStream = clob.getAsciiStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and file contents do not match", (boolean)this.compareLob2File(loopingAlphabetStream2, inputStream));
        loopingAlphabetStream2.close();
        inputStream.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobAsciiWrite3Param() throws Exception {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(this.streamSize[0]);
        LobStreamsTest.assertTrue((String)"FAIL -- file not found", (loopingAlphabetStream != null ? 1 : 0) != 0);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        int n = 0;
        byte[] byArray = new byte[1024];
        OutputStream outputStream = clob.setAsciiStream(1L);
        while ((n = loopingAlphabetStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        loopingAlphabetStream.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)this.streamSize[0], (long)l);
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(this.streamSize[0]);
        InputStream inputStream = clob.getAsciiStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and file contents do not match", (boolean)this.compareLob2File(loopingAlphabetStream2, inputStream));
        loopingAlphabetStream2.close();
        inputStream.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobCharacterWrite3ParamChar() throws Exception {
        char[] cArray = "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer writer = clob.setCharacterStream(1L);
        writer.write(cArray, 0, cArray.length);
        writer.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)cArray.length, (long)l);
        Reader reader = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray(cArray, reader));
        reader.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobCharacterWrite3ParamString() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer writer = clob.setCharacterStream(1L);
        writer.write("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)", 0, "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length());
        writer.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)"This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length(), (long)l);
        Reader reader = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray(), reader));
        reader.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobCharacterWrite1ParamString() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer writer = clob.setCharacterStream(1L);
        writer.write("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)");
        writer.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)"This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length(), (long)l);
        Reader reader = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray(), reader));
        reader.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testClobCharacterWrite1Char() throws Exception {
        char c = 'a';
        PreparedStatement preparedStatement = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer writer = clob.setCharacterStream(1L);
        writer.write(c);
        writer.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        preparedStatement2.setClob(1, clob);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        long l = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)1L, (long)l);
        Reader reader = clob.getCharacterStream();
        char c2 = (char)reader.read();
        LobStreamsTest.assertEquals((String)"FAIL - fetched Clob and original contents do not match", (char)c, (char)c2);
        reader.close();
        resultSet.close();
        preparedStatement.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LobStreamsTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(LobStreamsTest.class));
        if (JDBC.vmSupportsJDBC3()) {
            BaseTestSuite baseTestSuite2 = new BaseTestSuite("LobStreamsTest:encrypted");
            baseTestSuite2.addTestSuite(LobStreamsTest.class);
            baseTestSuite.addTest(Decorator.encryptedDatabase((Test)baseTestSuite2));
        }
        return baseTestSuite;
    }

    private int readBytesFromStream(byte[] byArray, InputStream inputStream) throws IOException {
        int n;
        int n2;
        for (n = 0; n < byArray.length; n += n2) {
            n2 = inputStream.read(byArray, n, byArray.length - n);
            if (n2 >= 0) continue;
            if (n != 0) break;
            return n2;
        }
        return n;
    }

    private boolean compareLob2File(InputStream inputStream, InputStream inputStream2) throws Exception {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[1024];
        int n = 0;
        int n2 = 0;
        do {
            n2 = this.readBytesFromStream(byArray, inputStream);
            n = this.readBytesFromStream(byArray2, inputStream2);
            if (Arrays.equals(byArray, byArray2)) continue;
            return false;
        } while (n2 > 0 && n > 0);
        inputStream.close();
        inputStream2.close();
        return true;
    }

    private boolean compareClobReader2CharArray(char[] cArray, Reader reader) throws Exception {
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        do {
            if ((n = reader.read(cArray2, n2, cArray.length - n2)) == -1) continue;
            n2 += n;
        } while (n != -1 && n2 < cArray.length);
        reader.close();
        return Arrays.equals(cArray, cArray2);
    }
}

