/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class TriggerGeneralTest
extends BaseJDBCTestCase {
    public static final String HEX_DIGIT = "\\p{XDigit}";
    public static final String LANG_DUPLICATE_KEY_CONSTRAINT = "23505";
    public static final String LANG_SYNTAX_ERROR = "42X01";
    public static final String LANG_COLUMN_NOT_FOUND_IN_TABLE = "42X14";
    public static final String LANG_NO_USER_DDL_IN_SYSTEM_SCHEMA = "42X62";
    public static final String LANG_OBJECT_NOT_FOUND = "42X94";
    public static final String LANG_NO_PARAMS_IN_TRIGGER_ACTION = "42Y27";
    public static final String LANG_DUPLICATE_COLUMN_IN_TRIGGER_UPDATE = "42Y40";
    public static final String LANG_OBJECT_DOES_NOT_EXIST = "42Y55";
    public static final String LANG_INVALID_OPERATION_ON_VIEW = "42Y62";
    public static final String LANG_TRIGGER_RECURSION_EXCEEDED = "54038";
    public static final String LANG_PROVIDER_HAS_DEPENDENT_OBJECT = "X0Y25";
    public static final String LANG_OBJECT_ALREADY_EXISTS_IN_OBJECT = "X0Y32";
    public static final String LANG_SCHEMA_NOT_EMPTY = "X0Y54";
    public static final String LANG_INVALID_OPERATION_ON_SYSTEM_TABLE = "X0Y56";
    private static PrintStream out;
    private static ByteArrayOutputStream outs;

    public TriggerGeneralTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.defaultSuite(TriggerGeneralTest.class);
        object = new SupportFilesSetup((Test)object, new String[]{"functionTests/tests/lang/dcl_emc1.jar"});
        return SecurityManagerSetup.noSecurityManager(object);
    }

    public void testTriggersInGeneral() throws Exception {
        int n;
        Statement statement = this.createStatement();
        outs = new ByteArrayOutputStream();
        out = new PrintStream(outs);
        statement.executeUpdate("create function triggerFiresMin(s varchar(128)) returns varchar(1) PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL  EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.TriggerGeneralTest.triggerFiresMinimal'");
        statement.executeUpdate("create function triggerFires(s varchar(128)) returns varchar(1) PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL  EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.TriggerGeneralTest.triggerFires'");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_DOES_NOT_EXIST, statement, "drop table x");
        statement.executeUpdate("create table x (x int, y int, z int, constraint ck1 check (x > 0))");
        statement.executeUpdate("create view v as select * from x");
        statement.executeUpdate("create trigger t1 NO CASCADE before update of x,y on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_ALREADY_EXISTS_IN_OBJECT, statement, "create trigger t1 NO CASCADE before update of x,y on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_ALREADY_EXISTS_IN_OBJECT, statement, "create trigger app.t1 NO CASCADE before update of x,y on x for each row values 1");
        ResultSet resultSet = statement.executeQuery("select cast(triggername as char(10)), event, firingtime, type, state, referencedcolumns from sys.systriggers");
        String[] stringArray = new String[]{"1", "EVENT", "FIRINGTIME", "TYPE", "STATE", "REFERENCEDCOLUMNS"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"T1", "U", "B", "R", "E", "(1,2)"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select cast(triggername as char(10)), CAST (TRIGGERDEFINITION AS VARCHAR(180)), STMTNAME from sys.systriggers t, sys.sysstatements s      where s.stmtid = t.actionstmtid");
        stringArray = new String[]{"1", "2", "STMTNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        resultSet.next();
        TriggerGeneralTest.assertEquals((String)"T1        ", (String)resultSet.getString(1));
        TriggerGeneralTest.assertEquals((String)"values 1", (String)resultSet.getString(2));
        TriggerGeneralTest.assertTrue((boolean)this.matchUUIDs(resultSet.getString(3)));
        TriggerGeneralTest.assertFalse((boolean)resultSet.next());
        resultSet = statement.executeQuery("select cast(triggername as char(10)), tablename from sys.systriggers t, sys.systables tb     where t.tableid = tb.tableid");
        stringArray = new String[]{"1", "TABLENAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"T1", "X"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', 'SYSTRIGGERS')");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger t1");
        TriggerGeneralTest.assertStatementError(LANG_NO_USER_DDL_IN_SYSTEM_SCHEMA, statement, "create trigger sys.tr NO CASCADE before insert on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_INVALID_OPERATION_ON_SYSTEM_TABLE, statement, "create trigger tr NO CASCADE before insert on sys.systables for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_DUPLICATE_COLUMN_IN_TRIGGER_UPDATE, statement, "create trigger tr NO CASCADE before update of x, x on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tr NO CASCADE before update of x, ? on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_COLUMN_NOT_FOUND_IN_TABLE, statement, "create trigger tr NO CASCADE before update of doesnotexist on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_INVALID_OPERATION_ON_VIEW, statement, "create trigger tr NO CASCADE before insert on v for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tr NO CASCADE before update of x.x on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tr NO CASCADE before update of app.x.x on x for each row values 1");
        TriggerGeneralTest.assertStatementError(LANG_NO_PARAMS_IN_TRIGGER_ACTION, statement, "create trigger tr NO CASCADE before delete on x for each row select * from x where x = ?");
        statement.executeUpdate("create trigger stmttrigger NO CASCADE before delete on x for each statement values 1");
        resultSet = statement.executeQuery("select triggername, type from sys.systriggers where triggername = 'STMTTRIGGER'");
        stringArray = new String[]{"TRIGGERNAME", "TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"STMTTRIGGER", "S"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger stmttrigger");
        statement.executeUpdate("create trigger rowtrigger NO CASCADE before delete on x for each row values 1");
        resultSet = statement.executeQuery("select triggername, type from sys.systriggers where triggername = 'ROWTRIGGER'");
        stringArray = new String[]{"TRIGGERNAME", "TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"ROWTRIGGER", "R"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger rowtrigger");
        statement.executeUpdate("create trigger t2 NO CASCADE before update of x,y on x for each row values 1");
        statement.executeUpdate("alter table x add constraint ck2 check(x > 0)");
        statement.executeUpdate("drop view v");
        statement.executeUpdate("create view v as select * from x");
        statement.executeUpdate("create index ix on x(x)");
        statement.executeUpdate("drop trigger t2");
        statement.executeUpdate("drop index ix");
        statement.executeUpdate("alter table x drop constraint ck2");
        statement.executeUpdate("create table y (x int, y int, z int)");
        statement.executeUpdate("create trigger tins after insert on x referencing new_table as newtab for each statement insert into y select x, y, z from newtab");
        statement.executeUpdate("insert into x values (1, 1, 1)");
        statement.executeUpdate("alter table x add column w int default 100");
        statement.executeUpdate("alter table x add constraint nonulls check (w is not null)");
        statement.executeUpdate("insert into x values (2, 2, 2, 2)");
        resultSet = statement.executeQuery("select * from y");
        stringArray = new String[]{"X", "Y", "Z"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}, {"2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger tins");
        statement.executeUpdate("drop table y");
        statement.executeUpdate("create trigger t2 NO CASCADE before update of x,y on x for each row values 1");
        statement.executeUpdate("create trigger t3 after update of x,y on x for each statement values 1");
        statement.executeUpdate("create trigger t4 after delete on x for each statement values 1");
        resultSet = statement.executeQuery("select cast(triggername as char(10)), tablename from sys.systriggers t, sys.systables  tb     where t.tableid = tb.tableid order by 1");
        stringArray = new String[]{"1", "TABLENAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"T2", "X"}, {"T3", "X"}, {"T4", "X"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop view v");
        statement.executeUpdate("drop table x");
        resultSet = statement.executeQuery("select cast(triggername as char(10)), tablename from sys.systriggers t, sys.systables  tb     where t.tableid = tb.tableid order by 1");
        stringArray = new String[]{"1", "TABLENAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("create table x (x int, y int, z int)");
        statement.executeUpdate("create schema test");
        statement.executeUpdate("create trigger test.t1 NO CASCADE before delete on x for each row values 1");
        statement.executeUpdate("set schema test");
        statement.executeUpdate("create trigger t2 NO CASCADE before delete on app.x for each row values 1");
        resultSet = statement.executeQuery("select schemaname, triggername from sys.systriggers t, sys.sysschemas s where s.schemaid = t.schemaid");
        stringArray = new String[]{"SCHEMANAME", "TRIGGERNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"TEST", "T1"}, {"TEST", "T2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("set schema app");
        TriggerGeneralTest.assertStatementError(LANG_SCHEMA_NOT_EMPTY, statement, "drop schema test restrict");
        statement.executeUpdate("drop trigger test.t2");
        TriggerGeneralTest.assertStatementError(LANG_SCHEMA_NOT_EMPTY, statement, "drop schema test restrict");
        statement.executeUpdate("set schema test");
        statement.executeUpdate("drop trigger t1");
        statement.executeUpdate("set schema app");
        statement.executeUpdate("drop schema test restrict");
        statement.executeUpdate("create table t (x int, y int, c char(1))");
        statement.executeUpdate("create trigger t1 after insert on t for each row values app.triggerFires('3rd')");
        statement.executeUpdate("create trigger t2 no cascade before insert on t for each statement values app.triggerFires('1st')");
        statement.executeUpdate("create trigger t3 after insert on t for each row values app.triggerFires('4th')");
        statement.executeUpdate("create trigger t4 no cascade before insert on t for each row values app.triggerFires('2nd')");
        statement.executeUpdate("create trigger t5 after insert on t for each statement values app.triggerFires('5th')");
        statement.executeUpdate("insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <1st> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{2,2,2}\n\t{3,3,3}\n\t{4,4,4}\n\nTRIGGER: <2nd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{2,2,2}\n\nTRIGGER: <2nd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{3,3,3}\n\nTRIGGER: <2nd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{4,4,4}\n\nTRIGGER: <3rd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{2,2,2}\n\nTRIGGER: <3rd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{3,3,3}\n\nTRIGGER: <3rd> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{4,4,4}\n\nTRIGGER: <4th> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{2,2,2}\n\nTRIGGER: <4th> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{3,3,3}\n\nTRIGGER: <4th> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{4,4,4}\n\nTRIGGER: <5th> on statement insert into t values (2,2,'2'),(3,3,'3'),(4,4,'4')\nBEFORE RESULT SET\n<NULL>\n\nAFTER RESULT SET\n\t X,Y,C\n\t - - -\n\t{2,2,2}\n\t{3,3,3}\n\t{4,4,4}\n\n");
        TriggerGeneralTest.assertUpdateCount(statement, 3, "delete from t");
        statement.executeUpdate("drop trigger t1");
        statement.executeUpdate("drop trigger t2");
        statement.executeUpdate("drop trigger t3");
        statement.executeUpdate("drop trigger t4");
        statement.executeUpdate("drop trigger t5");
        statement.executeUpdate("drop table x");
        statement.executeUpdate("drop table t");
        statement.executeUpdate("create table t (c1 int, c2 int)");
        statement.executeUpdate("create trigger tins after insert on t for each row values app.triggerFiresMin('insert')");
        statement.executeUpdate("create trigger tdel after delete on t for each row values app.triggerFiresMin('delete')");
        statement.executeUpdate("create trigger tupc1 after update of c1 on t for each row values app.triggerFiresMin('update c1')");
        statement.executeUpdate("create trigger tupc2 after update of c2 on t for each row values app.triggerFiresMin('update c2')");
        statement.executeUpdate("create trigger tupc1c2 after update of c1,c2 on t for each row values app.triggerFiresMin('update c1,c2')");
        statement.executeUpdate("create trigger tupc2c1 after update of c2,c1 on t for each row values app.triggerFiresMin('update c2,c1')");
        statement.executeUpdate("insert into t values (1,1)");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <insert>\n");
        statement.executeUpdate("update t set c1 = 1");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <update c1>\nTRIGGER: <update c1,c2>\nTRIGGER: <update c2,c1>\n");
        statement.executeUpdate("update t set c2 = 1");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <update c2>\nTRIGGER: <update c1,c2>\nTRIGGER: <update c2,c1>\n");
        statement.executeUpdate("update t set c2 = 1, c1 = 1");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <update c1>\nTRIGGER: <update c2>\nTRIGGER: <update c1,c2>\nTRIGGER: <update c2,c1>\n");
        statement.executeUpdate("update t set c1 = 1, c2 = 1");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <update c1>\nTRIGGER: <update c2>\nTRIGGER: <update c1,c2>\nTRIGGER: <update c2,c1>\n");
        statement.executeUpdate("delete from t");
        TriggerGeneralTest.assertTriggerOutput("TRIGGER: <delete>\n");
        statement.executeUpdate("create table trigtable(\"cOlUmN1\" int, \"cOlUmN2  \" int, \"cOlUmN3\"\"\"\"  \" int)");
        statement.executeUpdate("create table trighistory(\"cOlUmN1\" int, \"cOlUmN2  \" int, \"cOlUmN3\"\"\"\"  \" int)");
        statement.executeUpdate("insert into trigtable values (1, 2, 3)");
        statement.executeUpdate("create trigger \"tt1\" after insert on trigtable referencing NEW as NEW for each row insert into trighistory (\"cOlUmN1\", \"cOlUmN2  \", \"cOlUmN3\"\"\"\"  \") values (new.\"cOlUmN1\" + 5, \"NEW\".\"cOlUmN2  \" * new.\"cOlUmN3\"\"\"\"  \", 5)");
        resultSet = statement.executeQuery("select cast(triggername as char(10)), CAST (TRIGGERDEFINITION AS VARCHAR(180)), STMTNAME from sys.systriggers t, sys.sysstatements s      where s.stmtid = t.actionstmtid and triggername = 'tt1'");
        stringArray = new String[]{"1", "2", "STMTNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        resultSet.next();
        TriggerGeneralTest.assertEquals((String)"tt1       ", (String)resultSet.getString(1));
        TriggerGeneralTest.assertEquals((String)"insert into \"APP\".\"TRIGHISTORY\" (\"cOlUmN1\", \"cOlUmN2  \", \"cOlUmN3\"\"\"\"  \") values (new.\"cOlUmN1\" + 5, \"NEW\".\"cOlUmN2  \" * new.\"cOlUmN3\"\"\"\"  \", 5)", (String)resultSet.getString(2));
        TriggerGeneralTest.assertTrue((boolean)this.matchUUIDs(resultSet.getString(3)));
        TriggerGeneralTest.assertFalse((boolean)resultSet.next());
        statement.executeUpdate("insert into trigtable values (1, 2, 3)");
        resultSet = statement.executeQuery("select * from trighistory");
        stringArray = new String[]{"cOlUmN1", "cOlUmN2  ", "cOlUmN3\"\"  "};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "6", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger \"tt1\"");
        statement.executeUpdate("create trigger \"tt1\" after insert on trigtable referencing new as new for each row insert into trighistory (\"cOlUmN1\", \"cOlUmN2  \", \"cOlUmN3\"\"\"\"  \") values (new.\"cOlUmN1\" + new.\"cOlUmN1\", \"NEW\".\"cOlUmN2  \" * new.\"cOlUmN3\"\"\"\"  \", new.\"cOlUmN2  \" * 3)");
        resultSet = statement.executeQuery("select cast(triggername as char(10)), CAST (TRIGGERDEFINITION AS VARCHAR(180)), STMTNAME from sys.systriggers t, sys.sysstatements s      where s.stmtid = t.actionstmtid and triggername = 'tt1'");
        stringArray = new String[]{"1", "2", "STMTNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        resultSet.next();
        TriggerGeneralTest.assertEquals((String)"tt1       ", (String)resultSet.getString(1));
        TriggerGeneralTest.assertEquals((String)"insert into \"APP\".\"TRIGHISTORY\" (\"cOlUmN1\", \"cOlUmN2  \", \"cOlUmN3\"\"\"\"  \") values (new.\"cOlUmN1\" + new.\"cOlUmN1\", \"NEW\".\"cOlUmN2  \" * new.\"cOlUmN3\"\"\"\"  \", new.\"cOlUmN2  \" * 3)", (String)resultSet.getString(2));
        TriggerGeneralTest.assertTrue((boolean)this.matchUUIDs(resultSet.getString(3)));
        TriggerGeneralTest.assertFalse((boolean)resultSet.next());
        statement.executeUpdate("insert into trigtable values (1, 2, 3)");
        resultSet = statement.executeQuery("select * from trighistory");
        stringArray = new String[]{"cOlUmN1", "cOlUmN2  ", "cOlUmN3\"\"  "};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "6", "5"}, {"2", "6", "6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table trigtable");
        statement.executeUpdate("drop table trighistory");
        statement.executeUpdate("create table trigtable1(c1 int, c2 int)");
        statement.executeUpdate("create table trighistory(trigtable char(30), c1 int, c2 int)");
        statement.executeUpdate("create trigger trigtable1 after update on trigtable1 referencing OLD as oldtable for each row insert into trighistory values ('trigtable1', oldtable.c1, oldtable.c2)");
        statement.executeUpdate("insert into trigtable1 values (1, 1)");
        TriggerGeneralTest.assertUpdateCount(statement, 1, "update trigtable1 set c1 = 11, c2 = 11");
        resultSet = statement.executeQuery("select * from trighistory");
        stringArray = new String[]{"TRIGTABLE", "C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"trigtable1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table trigtable1");
        statement.executeUpdate("drop table trighistory");
        this.setAutoCommit(false);
        statement.executeUpdate("drop table t");
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create trigger tr after insert on t for each statement values 1");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?)");
        resultSet = statement.executeQuery("values (1)");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        BaseJDBCTestCase.assertUpdateCount(preparedStatement, 1);
        resultSet = statement.executeQuery("values (2)");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        BaseJDBCTestCase.assertUpdateCount(preparedStatement, 1);
        resultSet = statement.executeQuery("select * from t");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_DOES_NOT_EXIST, statement, "drop table db2sql");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_DOES_NOT_EXIST, statement, "drop table db2sql2");
        statement.executeUpdate("create table db2sql  (db2sql int, mode int, yipng int)");
        statement.executeUpdate("create table db2sql2 (db2sql2 int)");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_NOT_FOUND, statement, "drop trigger db2sqltr1");
        statement.executeUpdate("create trigger db2sqltr1 after insert on db2sql for each row MODE DB2SQL insert into db2sql2 values (1)");
        this.setAutoCommit(true);
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_DOES_NOT_EXIST, statement, "drop table parent");
        statement.executeUpdate("create table t1(a int not null primary key, b int)");
        statement.executeUpdate("create table parent (a int not null primary key, b int)");
        statement.executeUpdate("create trigger trig1 AFTER DELETE on t1 referencing OLD as OLD for each row delete from parent where a = OLD.a");
        statement.executeUpdate("insert into t1 values (0, 1)");
        statement.executeUpdate("insert into t1 values (1, 1)");
        statement.executeUpdate("insert into t1 values (2, 1)");
        statement.executeUpdate("insert into t1 values (3, 1)");
        statement.executeUpdate("insert into parent values (0, 1)");
        statement.executeUpdate("insert into parent values (1, 1)");
        statement.executeUpdate("insert into parent values (2, 1)");
        statement.executeUpdate("insert into parent values (3, 1)");
        statement.executeUpdate("insert into parent values (4, 1)");
        this.setAutoCommit(false);
        TriggerGeneralTest.assertUpdateCount(statement, 1, "delete from t1 where a = 3");
        long l = 60000L;
        boolean bl = false;
        stringArray = new String[]{"TYPE", "MODE", "TABLENAME"};
        objectArray = new String[][]{{"ROW", "X", "PARENT"}, {"TABLE", "IX", "PARENT"}, {"ROW", "X", "T1"}, {"TABLE", "IX", "T1"}};
        while (l >= 0L) {
            resultSet = statement.executeQuery("select type, mode, tablename from syscs_diag.lock_table order by tablename, type");
            JDBC.assertColumnNames(resultSet, stringArray);
            try {
                JDBC.assertFullResultSet(resultSet, objectArray, true);
                bl = true;
                break;
            }
            catch (AssertionFailedError assertionFailedError) {
                l -= 2000L;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!bl) {
            TriggerGeneralTest.dumpRs(statement.executeQuery("select * from syscs_diag.lock_table     order by tablename, type"));
            TriggerGeneralTest.fail((String)"Unexpected set of locks found");
        }
        this.rollback();
        this.setAutoCommit(true);
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table parent");
        statement.executeUpdate("create table x(x int)");
        statement.executeUpdate("insert into x values (2), (8), (78)");
        statement.executeUpdate("create table removed (x int)");
        statement.executeUpdate("create trigger t1 after update of x on x referencing old_table as old new_table as new for each statement insert into removed select x from old where x not in (select x from  new where x < 10)");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2"}, {"8"}, {"78"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from removed");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        TriggerGeneralTest.assertUpdateCount(statement, 1, "update x set x=18 where x=8");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2"}, {"18"}, {"78"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from removed");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create trigger t2 after update of x on x referencing old as oldrow new as newrow for each row insert into removed values (newrow.x + oldrow.x)");
        TriggerGeneralTest.assertUpdateCount(statement, 1, "update x set x=28 where x=18");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2"}, {"28"}, {"78"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from removed");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}, {"18"}, {"46"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table x add column y int");
        TriggerGeneralTest.assertUpdateCount(statement, 1, "update x set x=88 where x > 44");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X", "Y"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", null}, {"28", null}, {"88", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from removed");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}, {"18"}, {"46"}, {"78"}, {"166"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table x");
        statement.executeUpdate("drop table removed");
        statement.executeUpdate("create table x (x int, constraint ck check (x > 0))");
        statement.executeUpdate("create trigger tgood after insert on x for each statement insert into x values 666");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement, "insert into x values 1");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop trigger tgood");
        statement.executeUpdate("create trigger tgood after insert on x for each statement delete from x");
        statement.executeUpdate("insert into x values 1");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop trigger tgood");
        statement.executeUpdate("create trigger tgood after insert on x for each statement update x set x = x+100");
        statement.executeUpdate("insert into x values 1");
        resultSet = statement.executeQuery("select * from x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"101"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger tgood");
        TriggerGeneralTest.assertUpdateCount(statement, 1, "delete from x");
        statement.executeUpdate("create trigger tgood after insert on x for each statement insert into x values (666), (999), (333)");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement, "insert into x values 1");
        resultSet = statement.executeQuery("select * from x order by 1");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop trigger tgood");
        TriggerGeneralTest.assertUpdateCount(statement, 0, "delete from x");
        statement.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into x values (n.x)");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement, "insert into x values 7");
        resultSet = statement.executeQuery("select * from x order by 1");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop trigger tgood");
        TriggerGeneralTest.assertUpdateCount(statement, 0, "delete from x");
        statement.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into x values (333), (999), (333)");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement, "insert into x values 1");
        resultSet = statement.executeQuery("select * from x order by 1");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop trigger tgood");
        statement.executeUpdate("drop table x");
        statement.executeUpdate("create procedure d388 () language java parameter style java modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.lang.TriggerGeneralTest.derby388'");
        CallableStatement callableStatement = this.prepareCall("call d388()");
        BaseJDBCTestCase.assertUpdateCount(callableStatement, 0);
        Connection connection = this.openDefaultConnection("someuser", "pw");
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("create table myschema.mytable (i int)");
        statement2.executeUpdate("create trigger mytrigger after update on myschema.mytable for each row select * from sys.systables");
        connection.rollback();
        connection.close();
        this.setAutoCommit(true);
        statement.executeUpdate("create table t438 (id int,  cost decimal(6,2), bl blob)");
        statement.executeUpdate("create table t438_t (id int, bl blob, l int, nc decimal(6,2), oc decimal(6,2))");
        statement.executeUpdate("create trigger tr_438 after update on t438 referencing new as n old as o for each row insert into t438_t(id, bl, l, nc, oc) values (n.id, n.bl, length(n.bl), n.cost, o.cost)");
        statement.executeUpdate("insert into t438 values (1, 34.53, cast (X'124594322143423214ab35f2e34c' as blob))");
        statement.executeUpdate("insert into t438 values (0, 95.32, null)");
        statement.executeUpdate("insert into t438 values (2, 22.21, cast (X'aa' as blob))");
        resultSet = statement.executeQuery("select id, cost, length(bl) from t438 order by 1");
        stringArray = new String[]{"ID", "COST", "3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", "95.32", null}, {"1", "34.53", "14"}, {"2", "22.21", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertUpdateCount(statement, 3, "update t438 set cost = cost + 1.23");
        resultSet = statement.executeQuery("select id, length(bl), l, nc, oc from t438_t order by 1,5,4");
        stringArray = new String[]{"ID", "2", "L", "NC", "OC"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null, null, "96.55", "95.32"}, {"1", "14", "14", "35.76", "34.53"}, {"2", "1", "1", "23.44", "22.21"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select id, cast (bl as blob(20)) from t438 order by 1");
        stringArray = new String[]{"ID", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null}, {"1", "124594322143423214ab35f2e34c"}, {"2", "aa"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select id, cast (bl as blob(20)) from t438_t order by 1");
        stringArray = new String[]{"ID", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null}, {"1", "124594322143423214ab35f2e34c"}, {"2", "aa"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table t438");
        statement.executeUpdate("drop table t438_t");
        statement.executeUpdate("create table t438 (id int,  cost decimal(6,2), cl clob)");
        statement.executeUpdate("create table t438_t (id int, cl clob, l int, nc decimal(6,2), oc decimal(6,2))");
        statement.executeUpdate("create trigger tr_438 after update on t438 referencing new as n old as o for each row insert into t438_t(id, cl, l, nc, oc) values (n.id, n.cl, length(n.cl), n.cost, o.cost)");
        statement.executeUpdate("insert into t438 values (1, 34.53, cast ('Italy''s centre-left leader Romano Prodi insists his poll victory is valid as contested ballots are checked.' as clob))");
        statement.executeUpdate("insert into t438 values (0, 95.32, null)");
        statement.executeUpdate("insert into t438 values (2, 22.21, cast ('free' as clob))");
        resultSet = statement.executeQuery("select id, cost, length(cl) from t438 order by 1");
        stringArray = new String[]{"ID", "COST", "3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", "95.32", null}, {"1", "34.53", "107"}, {"2", "22.21", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertUpdateCount(statement, 3, "update t438 set cost = cost + 1.23");
        resultSet = statement.executeQuery("select id, length(cl), l, nc, oc from t438_t order by 1,5,4");
        stringArray = new String[]{"ID", "2", "L", "NC", "OC"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null, null, "96.55", "95.32"}, {"1", "107", "107", "35.76", "34.53"}, {"2", "4", "4", "23.44", "22.21"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select id, cast (cl as clob(60)) from t438 order by 1");
        stringArray = new String[]{"ID", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null}, {"1", "Italy's centre-left leader Romano Prodi insists his poll vic"}, {"2", "free"}};
        JDBC.assertFullResultSet(resultSet, objectArray, new String[]{"01004", "01004", "01004"});
        resultSet = statement.executeQuery("select id, cast (cl as clob(60)) from t438_t order by 1");
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", null}, {"1", "Italy's centre-left leader Romano Prodi insists his poll vic"}, {"2", "free"}};
        JDBC.assertFullResultSet(resultSet, objectArray, new String[]{"01004", "01004", "01004"});
        statement.executeUpdate("drop table t438");
        statement.executeUpdate("drop table t438_t");
        statement.executeUpdate("create table tsn (I integer, \"i\" integer)");
        statement.executeUpdate("create table tsn_t (a integer, b integer)");
        statement.executeUpdate("create trigger tr_sn after insert on tsn referencing new as n for each row insert into tsn_t(a, b) values (n.I, n.\"i\")");
        statement.executeUpdate("insert into tsn values (1, 234)");
        resultSet = statement.executeQuery("select * from tsn");
        stringArray = new String[]{"I", "i"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "234"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from tsn_t");
        stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "234"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table tsn");
        statement.executeUpdate("drop table tsn_t");
        statement.executeUpdate("CREATE TABLE T10641 ( X INT PRIMARY KEY )");
        statement.executeUpdate("CREATE TABLE T10641_DELETIONS ( X INT )");
        statement.executeUpdate("CREATE TABLE T10642 (    Y INT,    CONSTRAINT Y_AND_X FOREIGN KEY(Y) REFERENCES T10641(X) ON DELETE CASCADE)");
        statement.executeUpdate("CREATE TABLE T10642_DELETIONS ( Y INT )");
        statement.executeUpdate("CREATE TRIGGER TRIGGER_T10641    AFTER DELETE ON T10641    REFERENCING OLD AS OLD_ROW    FOR EACH ROW    INSERT INTO T10641_DELETIONS VALUES (OLD_ROW.X)");
        statement.executeUpdate("CREATE TRIGGER TRIGGER_T10642    AFTER DELETE ON T10642    REFERENCING OLD AS OLD_ROW    FOR EACH ROW    INSERT INTO T10642_DELETIONS VALUES (OLD_ROW.Y)");
        statement.executeUpdate("INSERT INTO T10641 VALUES (0)");
        statement.executeUpdate("INSERT INTO T10642 VALUES (0)");
        statement.executeUpdate("INSERT INTO T10641 VALUES (1)");
        statement.executeUpdate("INSERT INTO T10642 VALUES (1)");
        resultSet = statement.executeQuery("SELECT * FROM T10641");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM T10642");
        stringArray = new String[]{"Y"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertUpdateCount(statement, 2, "DELETE FROM T10641");
        resultSet = statement.executeQuery("SELECT * FROM T10641");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("SELECT * FROM T10642");
        stringArray = new String[]{"Y"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("SELECT * FROM T10641_DELETIONS");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM T10642_DELETIONS");
        stringArray = new String[]{"Y"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table test (testid integer not null     generated always as identity (start with 1, increment by 1),     info integer not null, ts timestamp not null default '1980-01-01-00.00.00.000000')");
        statement.executeUpdate("create trigger update_test     after update on test     referencing old as old     for each row     update test set ts=current_timestamp where testid=old.testid");
        statement.executeUpdate("insert into test(info) values (1),(2),(3)");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement, "UPDATE TEST SET INFO = 1 WHERE TESTID = 2");
        statement.executeUpdate("drop table test");
        statement.executeUpdate("create table t1 (i int)");
        statement.executeUpdate("create table t2 (i int)");
        statement.executeUpdate("create trigger tt after insert on t1 for each statement insert into t2 values 1");
        statement.executeUpdate("insert into t1 values 1");
        statement.executeUpdate("create unique index tu on t2(i)");
        TriggerGeneralTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into t1 values 1");
        resultSet = statement.executeQuery("select * from t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into t1 values 1");
        resultSet = statement.executeQuery("select * from t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop index tu");
        resultSet = statement.executeQuery("select * from t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("insert into t1 values 1");
        resultSet = statement.executeQuery("select * from t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger tt");
        statement.executeUpdate("create table t3 (i int)");
        statement.executeUpdate("create table t4 (i int)");
        statement.executeUpdate("create trigger tt2 after insert on t3 for each statement insert into t4 values 1");
        statement.executeUpdate("insert into t3 values 1");
        resultSet = statement.executeQuery("select * from t4");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertStatementError(LANG_PROVIDER_HAS_DEPENDENT_OBJECT, statement, "drop table t4");
        statement.executeUpdate("insert into t3 values 1");
        resultSet = statement.executeQuery("select * from t4");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create function max_value(x int, y int) returns int language java parameter style java external name 'java.lang.Math.max'");
        statement.executeUpdate("create table test(a integer)");
        statement.executeUpdate("create trigger test_trigger AFTER insert on test FOR EACH ROW values max_value(2,4)");
        statement.executeUpdate("insert into test values(1)");
        TriggerGeneralTest.assertStatementError(LANG_PROVIDER_HAS_DEPENDENT_OBJECT, statement, "drop function max_value");
        statement.executeUpdate("insert into test values(2)");
        statement.executeUpdate("insert into test values(1)");
        statement.executeUpdate("create table t11TriggerTest (c111 int not null primary key, c112 int)");
        statement.executeUpdate("insert into t11TriggerTest values(1,1)");
        statement.executeUpdate("insert into t11TriggerTest values(2,2)");
        statement.executeUpdate("create view v21ViewTest as select * from t11TriggerTest");
        statement.executeUpdate("create table t31TriggerTest (c311 int)");
        statement.executeUpdate("create table t32TriggerTest (c321 int)");
        statement.executeUpdate("create trigger tr31t31TriggerTest after insert on t31TriggerTest for each statement   insert into t32TriggerTest values (select c111 from v21ViewTest where c112=1)");
        statement.executeUpdate("insert into t31TriggerTest values(1)");
        resultSet = statement.executeQuery("select * from t31TriggerTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t32TriggerTest");
        stringArray = new String[]{"C321"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        TriggerGeneralTest.assertStatementError(LANG_PROVIDER_HAS_DEPENDENT_OBJECT, statement, "drop view v21ViewTest");
        statement.executeUpdate("insert into t31TriggerTest values(1)");
        resultSet = statement.executeQuery("select * from t31TriggerTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t32TriggerTest");
        stringArray = new String[]{"C321"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        Connection connection2 = this.openDefaultConnection("user1", "pw");
        Statement statement3 = connection2.createStatement();
        statement3.executeUpdate("create table ippo.t1 (i int)");
        statement3.executeUpdate("create table ippo.t2 (i int)");
        statement3.executeUpdate("create index ippo.idx2 on t2(i)");
        statement3.executeUpdate("create trigger ippo.tr1 after insert on ippo.t1 for each row mode db2sql    insert into ippo.t2 values 1");
        statement3.executeUpdate("insert into ippo.t1 values 1");
        statement3.executeUpdate("insert into ippo.t1 values 1");
        ResultSet resultSet2 = statement3.executeQuery("select * from ippo.t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement3.executeUpdate("drop index ippo.idx2");
        statement3.executeUpdate("insert into ippo.t1 values 1");
        resultSet2 = statement3.executeQuery("select * from ippo.t2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement3.executeUpdate("drop trigger ippo.tr1");
        statement3.executeUpdate("drop table ippo.t2");
        statement3.executeUpdate("drop table ippo.t1");
        statement3.executeUpdate("drop schema ippo restrict");
        statement3.executeUpdate("create table topt1 (i int)");
        statement3.executeUpdate("insert into topt1 values 1,2,3");
        statement3.executeUpdate("create table topt2 (i int)");
        TriggerGeneralTest.assertStatementError(LANG_SYNTAX_ERROR, statement3, "create trigger tropt after insert on topt1 for each mode db2sql insert into topt2 values 1");
        statement3.executeUpdate("create trigger tropt after insert on topt1 insert into topt2 values 1");
        statement3.executeUpdate("insert into topt1 values 4,5,6");
        resultSet = statement3.executeQuery("select * from topt2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tropt");
        TriggerGeneralTest.assertUpdateCount(statement3, 1, "delete from topt2");
        statement3.executeUpdate("create trigger tropt after insert on topt1 referencing new_table as new_opt1 insert into topt2 select * from new_opt1");
        statement3.executeUpdate("insert into topt1 values 7,8,9");
        resultSet = statement3.executeQuery("select * from topt2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"7"}, {"8"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tropt");
        TriggerGeneralTest.assertUpdateCount(statement3, 3, "delete from topt2");
        statement3.executeUpdate("create trigger tropt after insert on topt1 referencing new_table as new_opt1 for each statement insert into topt2 select * from new_opt1");
        statement3.executeUpdate("insert into topt1 values 10,11,12");
        resultSet = statement3.executeQuery("select * from topt2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"10"}, {"11"}, {"12"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tropt");
        TriggerGeneralTest.assertUpdateCount(statement3, 3, "delete from topt2");
        statement3.executeUpdate("create trigger tropt after update on topt1 referencing old as oldrow for each row insert into topt2 values oldrow.i");
        TriggerGeneralTest.assertUpdateCount(statement3, 12, "update topt1 set i=100");
        resultSet = statement3.executeQuery("select * from topt2");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}, {"11"}, {"12"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tropt");
        statement3.executeUpdate("drop table topt2");
        statement3.executeUpdate("drop table topt1");
        statement3.executeUpdate("create table x (x int)");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into x values (n.x), (999), (333)");
        TriggerGeneralTest.assertStatementError(LANG_TRIGGER_RECURSION_EXCEEDED, statement3, "insert into x values 1");
        resultSet = statement3.executeQuery("select * from x order by 1");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("drop table x");
        statement3.executeUpdate("create table x (i int)");
        statement3.executeUpdate("create table y (i int)");
        statement3.executeUpdate("create trigger tgood after insert on x for each statement insert into y values (666), (999), (333)");
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into y values (n.i)");
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into y values (333), (999), (333)");
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into y values (n.i), (999), (333)");
        statement3.executeUpdate("insert into x values (888)");
        resultSet = statement3.executeQuery("select * from y");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"888"}, {"999"}, {"333"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tgood");
        TriggerGeneralTest.assertUpdateCount(statement3, 1, "delete from x");
        TriggerGeneralTest.assertUpdateCount(statement3, 3, "delete from y");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into y values (n.i), (n.i+1), (n.i+2)");
        statement3.executeUpdate("insert into x values (1), (4), (7)");
        resultSet = statement3.executeQuery("select * from y");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("drop table x");
        statement3.executeUpdate("drop table y");
        statement3.executeUpdate("create table x (i int, j varchar(10))");
        statement3.executeUpdate("create table y (i int, j varchar(10))");
        statement3.executeUpdate("create trigger tgood after insert on x referencing new as n for each row insert into y values (0, 'X'), (n.i, 'Y'), (0, n.j), (n.i,n.j)");
        statement3.executeUpdate("insert into x values (1,'A'), (2,'B'), (3, 'C')");
        resultSet = statement3.executeQuery("select * from y");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", "X"}, {"1", "Y"}, {"0", "A"}, {"1", "A"}, {"0", "X"}, {"2", "Y"}, {"0", "B"}, {"2", "B"}, {"0", "X"}, {"3", "Y"}, {"0", "C"}, {"3", "C"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement3.executeUpdate("drop trigger tgood");
        statement3.executeUpdate("drop table x");
        statement3.executeUpdate("drop table y");
        connection2.close();
        Connection connection3 = this.openDefaultConnection("user1", "pw");
        Statement statement4 = connection3.createStatement();
        statement4.executeUpdate("set schema app");
        TriggerGeneralTest.assertStatementError(LANG_OBJECT_NOT_FOUND, statement4, "drop trigger app.tr1");
        statement4.executeUpdate("drop table app.t1");
        statement4.executeUpdate("create table app.t1 (i int, j int)");
        statement4.executeUpdate("insert into app.t1 values (1,10)");
        statement4.executeUpdate("create trigger app.tr1 after update of i on app.t1 referencing old as old for each row update t1 set j = old.j+1");
        TriggerGeneralTest.assertUpdateCount(statement4, 1, "update app.t1 set i=i+1");
        ResultSet resultSet3 = statement4.executeQuery("select * from app.t1");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet3, stringArray);
        objectArray = new String[][]{{"2", "11"}};
        JDBC.assertFullResultSet(resultSet3, objectArray, true);
        CallableStatement callableStatement2 = this.prepareCall("call sqlj.install_jar('file:extin/dcl_emc1.jar', 'APP.dcl_emc1', 0)");
        TriggerGeneralTest.assertUpdateCount(callableStatement2, 0);
        Connection connection4 = this.openDefaultConnection("user2", "pw");
        Statement statement5 = connection4.createStatement();
        TriggerGeneralTest.assertUpdateCount(statement5, 1, "update app.t1 set i=i+1");
        ResultSet resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"3", "12"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        CallableStatement callableStatement3 = this.prepareCall("call sqlj.replace_jar('file:extin/dcl_emc1.jar', 'APP.dcl_emc1')");
        TriggerGeneralTest.assertUpdateCount(callableStatement3, 0);
        TriggerGeneralTest.assertUpdateCount(statement5, 1, "update app.t1 set i=i+1");
        resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"4", "13"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        callableStatement3 = this.prepareCall("call sqlj.remove_jar('APP.dcl_emc1', 0)");
        TriggerGeneralTest.assertUpdateCount(callableStatement3, 0);
        TriggerGeneralTest.assertUpdateCount(statement5, 1, "update app.t1 set i=i+1");
        resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"5", "14"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        statement5.executeUpdate("drop trigger app.tr1");
        statement5.executeUpdate("drop table app.t1");
        statement4.executeUpdate("set schema app");
        statement4.executeUpdate("create table app.t1 (id int, i int, j int)");
        statement4.executeUpdate("insert into app.t1 values (1,10, 100)");
        statement4.executeUpdate("insert into app.t1 values (2,20, 200)");
        statement4.executeUpdate("insert into app.t1 values (3,30, 300)");
        statement4.executeUpdate("create trigger app.tr1 after update on app.t1 referencing old as oldt  new as newt for each row update t1 set t1.j = CASE WHEN (oldt.j < 100) THEN (oldt.j + 1) ELSE 1 END WHERE((newt.j is null) OR (oldt.j = newt.j)) AND newt.id = t1.id");
        TriggerGeneralTest.assertUpdateCount(statement4, 3, "update app.t1 set i=i+1");
        resultSet3 = statement4.executeQuery("select * from app.t1");
        stringArray = new String[]{"ID", "I", "J"};
        JDBC.assertColumnNames(resultSet3, stringArray);
        objectArray = new String[][]{{"1", "11", "1"}, {"2", "21", "1"}, {"3", "31", "1"}};
        JDBC.assertFullResultSet(resultSet3, objectArray, true);
        callableStatement2 = this.prepareCall("call sqlj.install_jar('file:extin/dcl_emc1.jar', 'APP.dcl_emc1', 0)");
        TriggerGeneralTest.assertUpdateCount(callableStatement2, 0);
        TriggerGeneralTest.assertUpdateCount(statement5, 3, "update app.t1 set i=i+1");
        resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"ID", "I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"1", "12", "2"}, {"2", "22", "2"}, {"3", "32", "2"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        callableStatement3 = this.prepareCall("call sqlj.replace_jar('file:extin/dcl_emc1.jar', 'APP.dcl_emc1')");
        TriggerGeneralTest.assertUpdateCount(callableStatement3, 0);
        TriggerGeneralTest.assertUpdateCount(statement5, 3, "update app.t1 set i=i+1");
        resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"ID", "I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"1", "13", "3"}, {"2", "23", "3"}, {"3", "33", "3"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        callableStatement3 = this.prepareCall("call sqlj.remove_jar('APP.dcl_emc1', 0)");
        TriggerGeneralTest.assertUpdateCount(callableStatement3, 0);
        TriggerGeneralTest.assertUpdateCount(statement5, 3, "update app.t1 set i=i+1");
        resultSet4 = statement5.executeQuery("select * from app.t1");
        stringArray = new String[]{"ID", "I", "J"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"1", "14", "4"}, {"2", "24", "4"}, {"3", "34", "4"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        statement5.executeUpdate("drop trigger app.tr1");
        statement5.executeUpdate("drop table app.t1");
        connection4.close();
        connection3.close();
    }

    public static void derby388() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        boolean bl = !connection.getAutoCommit();
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE D388_T1 (ID INT)");
        statement.execute("CREATE TABLE D388_T2 (ID_2 INT)");
        statement.execute("CREATE TRIGGER D388_TRIG1 AFTER UPDATE OF ID ON D388_T1   REFERENCING NEW AS N_ROW FOR EACH ROW   UPDATE D388_T2   SET ID_2 =      CASE WHEN (N_ROW.ID <= 0) THEN N_ROW.ID     ELSE 6 END    WHERE N_ROW.ID < ID_2");
        if (bl) {
            connection.commit();
        }
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO D388_T1 VALUES (?)");
        PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT INTO D388_T2(ID_2) VALUES (?)");
        Statement statement2 = connection.createStatement();
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 10; ++j) {
                preparedStatement2.setInt(1, j);
                preparedStatement2.executeUpdate();
                preparedStatement.setInt(1, 2 * j);
                preparedStatement.executeUpdate();
                if (!bl) continue;
                connection.commit();
            }
            statement2.execute("UPDATE D388_T1 SET ID=5");
            if (!bl) continue;
            connection.commit();
        }
        statement.execute("DROP TABLE D388_T1");
        statement.execute("DROP TABLE D388_T2");
        if (bl) {
            connection.commit();
        }
        statement2.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public static String triggerFiresMinimal(String string) throws Throwable {
        out.println("TRIGGER: <" + string + ">");
        return "";
    }

    public static String triggerFires(String string) throws Throwable {
        TriggerExecutionContext triggerExecutionContext = Factory.getTriggerExecutionContext();
        out.println("TRIGGER: <" + string + "> on statement " + triggerExecutionContext.getEventStatementText());
        TriggerGeneralTest.printTriggerChanges();
        return "";
    }

    private static void printTriggerChanges() throws Throwable {
        TriggerExecutionContext triggerExecutionContext = Factory.getTriggerExecutionContext();
        out.println("BEFORE RESULT SET");
        BaseJDBCTestCase.dumpRs(triggerExecutionContext.getOldRowSet(), out);
        out.println("\nAFTER RESULT SET");
        BaseJDBCTestCase.dumpRs(triggerExecutionContext.getNewRowSet(), out);
    }

    private static void assertTriggerOutput(String string) {
        String string2 = outs.toString().replaceAll("\r", "");
        TriggerGeneralTest.assertEquals((String)string, (String)string2);
        outs.reset();
    }

    private boolean matchUUIDs(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        this.addPat(stringBuilder, HEX_DIGIT, 8);
        for (n = 0; n < 3; ++n) {
            stringBuilder.append("-");
            this.addPat(stringBuilder, HEX_DIGIT, 4);
        }
        stringBuilder.append("-");
        this.addPat(stringBuilder, HEX_DIGIT, 12);
        stringBuilder.append('_');
        this.addPat(stringBuilder, HEX_DIGIT, 8);
        for (n = 0; n < 3; ++n) {
            stringBuilder.append("-");
            this.addPat(stringBuilder, HEX_DIGIT, 4);
        }
        stringBuilder.append("-");
        this.addPat(stringBuilder, HEX_DIGIT, 12);
        Pattern pattern = Pattern.compile("TRIGGERACTN_" + stringBuilder.toString());
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private void addPat(StringBuilder stringBuilder, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
    }
}

