/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SpawnedProcess;

public class Derby5730Test
extends BaseTestCase {
    private static final Integer ZERO = Integer.valueOf("0");
    private static final Integer ONE = Integer.valueOf("1");
    private static final Integer TWO = Integer.valueOf("2");
    private static final Object[][] FUNCTIONS = new Object[][]{{"ACOS", ONE}, {"ASIN", ONE}, {"ATAN", ONE}, {"ATAN2", TWO}, {"COS", ONE}, {"SIN", ONE}, {"TAN", ONE}, {"PI", ZERO}, {"DEGREES", ONE}, {"RADIANS", ONE}, {"LN", ONE}, {"LOG", ONE}, {"LOG10", ONE}, {"EXP", ONE}, {"CEIL", ONE}, {"CEILING", ONE}, {"FLOOR", ONE}, {"SIGN", ONE}, {"RANDOM", ZERO}, {"RAND", ONE}, {"COT", ONE}, {"COSH", ONE}, {"SINH", ONE}, {"TANH", ONE}};

    public Derby5730Test(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            return new BaseTestSuite(Derby5730Test.class);
        }
        return new BaseTestSuite("Derby5730Test - skipped");
    }

    public void testLeak() throws IOException {
        String[] stringArray = new String[]{"-Xmx16M", ((Object)((Object)this)).getClass().getName()};
        SpawnedProcess spawnedProcess = new SpawnedProcess(Derby5730Test.execJavaCmd(stringArray), "DERBY-5730");
        if (spawnedProcess.complete() != 0) {
            Derby5730Test.fail((String)spawnedProcess.getFailMessage("Process failed"));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        for (int i = 0; i < FUNCTIONS.length; ++i) {
            Connection connection = DriverManager.getConnection("jdbc:derby:memory:derby5730;create=true");
            Derby5730Test.prepareFunction(connection, (String)FUNCTIONS[i][0], (Integer)FUNCTIONS[i][1]);
            Derby5730Test.growDatabaseFootprint(connection);
            connection.close();
            try {
                DriverManager.getConnection("jdbc:derby:memory:derby5730;shutdown=true");
                Derby5730Test.fail((String)"Shutdown should throw exception");
                continue;
            }
            catch (SQLException sQLException) {
                BaseJDBCTestCase.assertSQLState("08006", sQLException);
            }
        }
    }

    private static void prepareFunction(Connection connection, String string, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("VALUES ");
        stringBuffer.append(string);
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
        }
        stringBuffer.append(')');
        String string2 = stringBuffer.toString();
        System.out.println(string2);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.close();
    }

    private static void growDatabaseFootprint(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        JDBC.assertDrainResults(databaseMetaData.getColumns(null, "%", "%", "%"));
        JDBC.assertDrainResults(databaseMetaData.getTables(null, "%", "%", null));
    }
}

