/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesDependencyTest
extends BaseJDBCTestCase {
    public RolesDependencyTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = new BaseTestSuite(RolesDependencyTest.class);
        object = new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create schema s1");
                statement.execute("create table s1.t1(x int)");
                statement.execute("insert into s1.t1 values 1");
                statement.execute("create role role1");
                statement.execute("grant select on s1.t1 to role1");
                statement.execute("grant role1 to user1");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator((Test)object);
    }

    public void testCurrentRoleDependencyMemleak() throws SQLException {
        Connection connection = this.openUserConnection("user1");
        Statement statement = connection.createStatement();
        statement.execute("set role role1");
        for (int i = 0; i < 40000; ++i) {
            ResultSet resultSet = statement.executeQuery("select * from s1.t1");
            JDBC.assertDrainResults(resultSet, 1);
        }
        statement.close();
        connection.close();
    }
}

