/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.NullFilter;
import org.apache.fop.pdf.PDFFilter;

public class PDFFilterList {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String TIFF_FILTER = "tiff";
    public static final String FONT_FILTER = "font";
    public static final String METADATA_FILTER = "metadata";
    private List filters = new ArrayList();
    private boolean ignoreASCIIFilters = false;
    protected static Log logger = LogFactory.getLog((String)"org.apache.fop.render");

    public PDFFilterList() {
    }

    public PDFFilterList(boolean ignoreASCIIFilters) {
        this.ignoreASCIIFilters = ignoreASCIIFilters;
    }

    public boolean isInitialized() {
        return this.filters.size() > 0;
    }

    public void addFilter(PDFFilter filter) {
        if (filter != null) {
            if (this.ignoreASCIIFilters && filter.isASCIIFilter()) {
                return;
            }
            this.filters.add(filter);
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("null")) {
            this.addFilter(new NullFilter());
        } else if (filterType.equals("ascii-85")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    public void ensureFilterInPlace(PDFFilter pdfFilter) {
        if (this.filters.size() == 0) {
            this.addFilter(pdfFilter);
        } else if (!this.filters.get(0).equals(pdfFilter)) {
            this.filters.add(0, pdfFilter);
        }
    }

    public void addDefaultFilters(Map filters, String type) {
        List filterset = null;
        if (filters != null && (filterset = (List)filters.get(type)) == null) {
            filterset = (List)filters.get(DEFAULT_FILTER);
        }
        if (filterset == null || filterset.size() == 0) {
            if (METADATA_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (JPEG_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (TIFF_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else {
                this.addFilter(new FlateFilter());
            }
        } else {
            for (int i = 0; i < filterset.size(); ++i) {
                String v = (String)filterset.get(i);
                this.addFilter(v);
            }
        }
    }

    protected String buildFilterDictEntries() {
        if (this.filters != null && this.filters.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> parms = new ArrayList<String>();
            int nonNullParams = 0;
            for (int count = 0; count < this.filters.size(); ++count) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                if (filter.getName().length() <= 0) continue;
                names.add(0, filter.getName());
                if (filter.getDecodeParms() != null) {
                    parms.add(0, filter.getDecodeParms());
                    ++nonNullParams;
                    continue;
                }
                parms.add(0, null);
            }
            return this.buildFilterEntries(names) + (nonNullParams > 0 ? this.buildDecodeParms(parms) : "");
        }
        return "";
    }

    private String buildFilterEntries(List names) {
        int filterCount = 0;
        StringBuffer sb = new StringBuffer(64);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (name.length() <= 0) continue;
            ++filterCount;
            sb.append(name);
            sb.append(" ");
        }
        if (filterCount > 0) {
            if (filterCount > 1) {
                return "/Filter [ " + sb.toString() + "]";
            }
            return "/Filter " + sb.toString();
        }
        return "";
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("\n/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        for (int count = 0; count < parms.size(); ++count) {
            String s = (String)parms.get(count);
            if (s != null) {
                sb.append(s);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }

    public OutputStream applyFilters(OutputStream stream) throws IOException {
        OutputStream out = stream;
        if (this.filters != null) {
            for (int count = this.filters.size() - 1; count >= 0; --count) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                out = filter.applyFilter(out);
            }
        }
        return out;
    }

    public static Map buildFilterMapFromConfiguration(Configuration cfg) throws ConfigurationException {
        HashMap filterMap = new HashMap();
        Configuration[] filterLists = cfg.getChildren("filterList");
        for (int i = 0; i < filterLists.length; ++i) {
            Configuration filters = filterLists[i];
            String type = filters.getAttribute("type", null);
            Configuration[] filt = filters.getChildren("value");
            ArrayList<String> filterList = new ArrayList<String>();
            for (int j = 0; j < filt.length; ++j) {
                String name = filt[j].getValue();
                filterList.add(name);
            }
            if (type == null) {
                type = DEFAULT_FILTER;
            }
            if (!filterList.isEmpty() && logger.isDebugEnabled()) {
                StringBuffer debug = new StringBuffer("Adding PDF filter");
                if (filterList.size() != 1) {
                    debug.append("s");
                }
                debug.append(" for type ").append(type).append(": ");
                for (int j = 0; j < filterList.size(); ++j) {
                    if (j != 0) {
                        debug.append(", ");
                    }
                    debug.append(filterList.get(j));
                }
                logger.debug((Object)debug.toString());
            }
            if (filterMap.get(type) != null) {
                throw new ConfigurationException("A filterList of type '" + type + "' has already been defined");
            }
            filterMap.put(type, filterList);
        }
        return filterMap;
    }
}

