/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class SpillHashTest
extends BaseJDBCTestCase {
    private static final String[] prep = new String[]{"create table ta (ca1 integer, ca2 char(200))", "create table tb (cb1 integer, cb2 char(200))", "insert into ta(ca1,ca2) values(null, 'Anull')", "insert into tb(cb1,cb2) values(null, 'Bnull')"};
    private static final String[][] initDupVals = new String[][]{{"0a", "0b"}, {"1a", "1b"}, {"2a"}};
    private static final String[][] spillDupVals = new String[][]{new String[0], {"1c"}, {"2b"}, {"3a", "3b", "3c"}};
    private static final int LOTS_OF_ROWS = 10000;
    private PreparedStatement joinStmt;
    private PreparedStatement distinctStmt;

    public SpillHashTest(String name) {
        super(name);
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite light = new BaseTestSuite();
        BaseTestSuite heavy = new BaseTestSuite();
        light.addTest((Test)new SpillHashTest("testJoinLight"));
        light.addTest((Test)new SpillHashTest("testDistinctLight"));
        light.addTest((Test)new SpillHashTest("testCursorLight"));
        heavy.addTest((Test)new SpillHashTest("testJoinHeavy"));
        heavy.addTest((Test)new SpillHashTest("testDistinctHeavy"));
        heavy.addTest((Test)new SpillHashTest("testCursorHeavy"));
        BaseJDBCTestSetup lightSetup = new BaseJDBCTestSetup((Test)light){

            protected void setUp() throws Exception {
                super.setUp();
                Statement stmt = this.getConnection().createStatement();
                PreparedStatement insA = stmt.getConnection().prepareStatement("insert into ta(ca1,ca2) values(?,?)");
                PreparedStatement insB = stmt.getConnection().prepareStatement("insert into tb(cb1,cb2) values(?,?)");
                SpillHashTest.insertDups(insA, insB, initDupVals);
                this.getConnection().commit();
                stmt.close();
            }
        };
        BaseJDBCTestSetup heavySetup = new BaseJDBCTestSetup((Test)heavy){

            protected void setUp() throws Exception {
                super.setUp();
                Statement stmt = this.getConnection().createStatement();
                PreparedStatement insA = stmt.getConnection().prepareStatement("insert into ta(ca1,ca2) values(?,?)");
                PreparedStatement insB = stmt.getConnection().prepareStatement("insert into tb(cb1,cb2) values(?,?)");
                for (int i = 1; i <= 10000; ++i) {
                    insA.setInt(1, i);
                    insA.setString(2, SpillHashTest.ca2Val(i));
                    insA.executeUpdate();
                    insB.setInt(1, i);
                    insB.setString(2, SpillHashTest.cb2Val(i));
                    insB.executeUpdate();
                    if ((i & 0xFF) != 0) continue;
                    stmt.getConnection().commit();
                }
                SpillHashTest.insertDups(insA, insB, spillDupVals);
                this.getConnection().commit();
                stmt.close();
            }
        };
        BaseTestSuite mainSuite = new BaseTestSuite();
        mainSuite.addTest((Test)lightSetup);
        mainSuite.addTest((Test)heavySetup);
        return new CleanDatabaseTestSetup((Test)mainSuite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                for (int i = 0; i < prep.length; ++i) {
                    stmt.executeUpdate(prep[i]);
                }
            }
        };
    }

    protected void setUp() throws Exception {
        this.joinStmt = this.getConnection().prepareStatement("select ta.ca1, ta.ca2, tb.cb2 from ta, tb where ca1 = cb1");
        this.distinctStmt = this.getConnection().prepareStatement("select distinct ca1 from ta");
    }

    @Override
    protected void tearDown() throws Exception {
        this.joinStmt.close();
        this.distinctStmt.close();
        this.joinStmt = null;
        this.distinctStmt = null;
        super.tearDown();
    }

    public void testJoinLight() throws SQLException {
        this.runJoin(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testDistinctLight() throws SQLException {
        this.runDistinct(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testCursorLight() throws SQLException {
        SpillHashTest.runCursor(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testJoinHeavy() throws SQLException {
        this.runJoin(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    public void testDistinctHeavy() throws SQLException {
        this.runDistinct(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    public void testCursorHeavy() throws SQLException {
        SpillHashTest.runCursor(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    private static void insertDups(PreparedStatement insA, PreparedStatement insB, String[][] dupVals) throws SQLException {
        for (int i = 0; i < dupVals.length; ++i) {
            insA.setInt(1, -i);
            insB.setInt(1, -i);
            String[] vals = dupVals[i];
            for (int j = 0; j < vals.length; ++j) {
                insA.setString(2, "A" + vals[j]);
                insA.executeUpdate();
                insB.setString(2, "B" + vals[j]);
                insB.executeUpdate();
            }
        }
    }

    private static String ca2Val(int col1Val) {
        return "A" + col1Val;
    }

    private static String cb2Val(int col1Val) {
        return "B" + col1Val;
    }

    private void runJoin(Connection conn, int maxColValue, String[][][] dupVals) throws SQLException {
        int expectedRowCount = maxColValue;
        ResultSet rs = this.joinStmt.executeQuery();
        BitSet joinRowFound = new BitSet(maxColValue);
        int dupKeyCount = 0;
        for (int i = 0; i < dupVals.length; ++i) {
            if (dupVals[i].length <= dupKeyCount) continue;
            dupKeyCount = dupVals[i].length;
        }
        BitSet[] dupsFound = new BitSet[dupKeyCount];
        int[] dupCount = new int[dupKeyCount];
        for (int i = 0; i < dupKeyCount; ++i) {
            dupCount[i] = 0;
            for (int j = 0; j < dupVals.length; ++j) {
                if (i >= dupVals[j].length) continue;
                int n = i;
                dupCount[n] = dupCount[n] + dupVals[j][i].length;
            }
            dupsFound[i] = new BitSet(dupCount[i] * dupCount[i]);
            expectedRowCount += dupCount[i] * dupCount[i];
        }
        int count = 0;
        while (rs.next()) {
            int col1Val = rs.getInt(1);
            SpillHashTest.assertFalse((String)"Null in join column.", (boolean)rs.wasNull());
            SpillHashTest.assertFalse((String)"Invalid value in first join column.", (col1Val > maxColValue ? 1 : 0) != 0);
            if (col1Val > 0) {
                SpillHashTest.assertFalse((String)("Multiple rows for value " + col1Val), (boolean)joinRowFound.get(col1Val - 1));
                joinRowFound.set(col1Val - 1);
                String col2Val = SpillHashTest.trim(rs.getString(2));
                String col3Val = SpillHashTest.trim(rs.getString(3));
                SpillHashTest.assertFalse((String)"Incorrect value in column 2 or 3 of join.", (!SpillHashTest.ca2Val(col1Val).equals(col2Val) || !SpillHashTest.cb2Val(col1Val).equals(col3Val) ? 1 : 0) != 0);
            } else {
                int dupKeyIdx = -col1Val;
                int col2Idx = SpillHashTest.findDupVal(rs, 2, 'A', dupKeyIdx, dupVals);
                int col3Idx = SpillHashTest.findDupVal(rs, 3, 'B', dupKeyIdx, dupVals);
                if (col2Idx >= 0 && col3Idx >= 0) {
                    int idx = col2Idx + dupCount[dupKeyIdx] * col3Idx;
                    SpillHashTest.assertFalse((String)"Repeat of row with key value 0", (boolean)dupsFound[dupKeyIdx].get(idx));
                    dupsFound[dupKeyIdx].set(idx);
                }
            }
            ++count;
        }
        SpillHashTest.assertEquals((String)"Incorrect number of rows in join.", (int)expectedRowCount, (int)count);
        rs.close();
    }

    private static int findDupVal(ResultSet rs, int col, char prefix, int keyIdx, String[][][] dupVals) throws SQLException {
        String colVal = rs.getString(col);
        if (colVal != null && colVal.length() > 1 || colVal.charAt(0) == prefix) {
            colVal = SpillHashTest.trim(colVal.substring(1));
            int dupIdx = 0;
            for (int i = 0; i < dupVals.length; ++i) {
                if (keyIdx >= dupVals[i].length) continue;
                int j = 0;
                while (j < dupVals[i][keyIdx].length) {
                    if (colVal.equals(dupVals[i][keyIdx][j])) {
                        return dupIdx;
                    }
                    ++j;
                    ++dupIdx;
                }
            }
        }
        SpillHashTest.fail((String)("Incorrect value in column " + col + " of join with duplicate keys."));
        return -1;
    }

    private static String trim(String str) {
        if (str == null) {
            return str;
        }
        return str.trim();
    }

    private void runDistinct(Connection conn, int maxColValue, String[][][] dupVals) throws SQLException {
        ResultSet rs = this.distinctStmt.executeQuery();
        SpillHashTest.checkAllCa1(rs, false, false, maxColValue, dupVals, "DISTINCT");
        rs.close();
    }

    private static void runCursor(Connection conn, int maxColValue, String[][][] dupVals) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        boolean holdOverCommit = dmd.supportsOpenCursorsAcrossCommit();
        Statement stmt = holdOverCommit ? conn.createStatement(1004, 1007, 1) : conn.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("SELECT ca1 FROM ta");
        SpillHashTest.checkAllCa1(rs, true, holdOverCommit, maxColValue, dupVals, "scroll insensitive cursor");
        rs.close();
    }

    private static void checkAllCa1(ResultSet rs, boolean expectDups, boolean holdOverCommit, int maxColValue, String[][][] dupVals, String label) throws SQLException {
        int dupKeyCount = 0;
        for (int i = 0; i < dupVals.length; ++i) {
            if (dupVals[i].length <= dupKeyCount) continue;
            dupKeyCount = dupVals[i].length;
        }
        int[] expectedDupCount = new int[dupKeyCount];
        int[] dupFoundCount = new int[dupKeyCount];
        for (int i = 0; i < dupKeyCount; ++i) {
            dupFoundCount[i] = 0;
            if (!expectDups) {
                expectedDupCount[i] = 1;
                continue;
            }
            expectedDupCount[i] = 0;
            for (int j = 0; j < dupVals.length; ++j) {
                if (i >= dupVals[j].length) continue;
                int n = i;
                expectedDupCount[n] = expectedDupCount[n] + dupVals[j][i].length;
            }
        }
        BitSet found = new BitSet(maxColValue);
        int count = 0;
        boolean nullFound = false;
        count = 0;
        while (rs.next()) {
            int col1Val = rs.getInt(1);
            if (rs.wasNull()) {
                if (nullFound) {
                    SpillHashTest.fail((String)("Too many nulls returned by " + label));
                }
                nullFound = true;
                continue;
            }
            SpillHashTest.assertFalse((String)("Invalid value returned by " + label), (col1Val <= -dupKeyCount || col1Val > maxColValue ? 1 : 0) != 0);
            if (col1Val <= 0) {
                int n = -col1Val;
                dupFoundCount[n] = dupFoundCount[n] + 1;
                if (!expectDups) {
                    SpillHashTest.assertFalse((String)(label + " returned a duplicate."), (dupFoundCount[-col1Val] > 1 ? 1 : 0) != 0);
                } else {
                    SpillHashTest.assertFalse((String)(label + " returned too many duplicates."), (dupFoundCount[-col1Val] > expectedDupCount[-col1Val] ? 1 : 0) != 0);
                }
            } else {
                SpillHashTest.assertFalse((String)(label + " returned a duplicate."), (boolean)found.get(col1Val));
                found.set(col1Val);
                ++count;
            }
            if (!holdOverCommit) continue;
            rs.getStatement().getConnection().commit();
            holdOverCommit = false;
        }
        SpillHashTest.assertFalse((String)("Incorrect number of rows in " + label), (count != maxColValue ? 1 : 0) != 0);
        for (int i = 0; i < dupFoundCount.length; ++i) {
            SpillHashTest.assertFalse((String)("A duplicate key row is missing in " + label), (dupFoundCount[i] != expectedDupCount[i] ? 1 : 0) != 0);
        }
    }
}

