/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.testData.serializedDataSources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.derby.tools.sysinfo;

public class SerializeDataSources {
    private static final String[] KNOWN_EMBEDDED_DATA_SOURCES = new String[]{"org.apache.derby.jdbc.EmbeddedDataSource", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "org.apache.derby.jdbc.EmbeddedXADataSource", "org.apache.derby.jdbc.EmbeddedDataSource40", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource40", "org.apache.derby.jdbc.EmbeddedXADataSource40", "org.apache.derby.jdbc.BasicEmbeddedDataSource40", "org.apache.derby.jdbc.BasicEmbeddedConnectionPoolDataSource40", "org.apache.derby.jdbc.BasicEmbeddedXADataSource40"};
    private static final String[] KNOWN_CLIENT_DATA_SOURCES = new String[]{"org.apache.derby.jdbc.ClientDataSource", "org.apache.derby.jdbc.ClientConnectionPoolDataSource", "org.apache.derby.jdbc.ClientXADataSource", "org.apache.derby.jdbc.ClientDataSource40", "org.apache.derby.jdbc.ClientConnectionPoolDataSource40", "org.apache.derby.jdbc.ClientXADataSource40", "org.apache.derby.jdbc.BasicClientDataSource40", "org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40", "org.apache.derby.jdbc.BasicClientXADataSource40"};

    private static int serializeDataSources(String string, String string2, String[] stringArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, NamingException, NoSuchMethodException, InvocationTargetException {
        String string3 = string.replaceAll("\\.", "_");
        string3 = string3.replaceAll(" alpha", "");
        string3 = string3.replaceAll("_0_0", "_1_0");
        int n = 0;
        for (String string4 : stringArray) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("\tcouldn't load " + string4);
                continue;
            }
            DataSource dataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            File file = new File(clazz.getSimpleName() + "-" + string3 + ".ser");
            System.out.println("\twriting " + file.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeUTF(string);
            objectOutputStream.writeUTF(string2);
            objectOutputStream.writeObject(dataSource);
            if (!string4.contains("Basic")) {
                Method method = Class.forName("javax.naming.Referenceable").getMethod("getReference", new Class[0]);
                Object object = method.invoke((Object)dataSource, new Object[0]);
                objectOutputStream.writeObject(object);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            ++n;
        }
        return n;
    }

    private static boolean printInfoFromSerializedFile(String string) {
        System.out.println(">>> File: " + string);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("\tFile does not exist.");
            return false;
        }
        if (!file.canRead()) {
            System.out.println("\tCannot read file.");
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            String string2 = objectInputStream.readUTF();
            System.out.println("\tversion: " + string2);
            String string3 = objectInputStream.readUTF();
            System.out.println("\tbuild  : " + string3);
            Object object = objectInputStream.readObject();
            System.out.println("\tobject : " + object);
            if (object.getClass().getName().indexOf("Basic") <= 0) {
                object = objectInputStream.readObject();
                System.out.println("\tobject : " + object);
            }
        }
        catch (Exception exception) {
            System.out.println("\t!! De-serialization failed: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        int n3 = sysinfo.getMajorVersion((String)"engine");
        int n4 = sysinfo.getMinorVersion((String)"engine");
        String string = sysinfo.getBuildNumber((String)"engine");
        String string2 = sysinfo.getVersionString((String)"engine");
        int n5 = sysinfo.getMajorVersion((String)"client");
        int n6 = sysinfo.getMinorVersion((String)"client");
        String string3 = sysinfo.getBuildNumber((String)"client");
        String string4 = sysinfo.getVersionString((String)"client");
        if (stringArray.length > 0) {
            System.out.println("Reading files with the Derby version(s):");
            System.out.println("\tembedded: " + string2);
            System.out.println("\tclient  : " + string4);
            System.out.println();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = SerializeDataSources.printInfoFromSerializedFile(stringArray[n2]);
                System.out.println("File read successfully: " + (n != 0));
                System.out.println();
            }
            System.exit(0);
        }
        n2 = KNOWN_EMBEDDED_DATA_SOURCES.length + KNOWN_CLIENT_DATA_SOURCES.length;
        n = 0;
        if (n3 != -1 && n4 != -1) {
            System.out.println("Serializing embedded data sources for Derby version " + string2);
            n += SerializeDataSources.serializeDataSources(string2, string, KNOWN_EMBEDDED_DATA_SOURCES);
        } else {
            System.err.println("No embedded data sources will be generated because Derby version can't be determined.");
        }
        if (n5 != -1 && n6 != -1) {
            System.out.println("Serializing client data sources for Derby version " + string4);
            n += SerializeDataSources.serializeDataSources(string4, string3, KNOWN_CLIENT_DATA_SOURCES);
        } else {
            System.err.println("No client data sources will be generated because Derby version can't be determined.");
        }
        System.out.println();
        System.out.println("Known data sources:   " + n2);
        System.out.println("Data sources written: " + n);
    }
}

