/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.vti.StringColumnVTI;

public class RSMDWrapper
extends StringColumnVTI {
    private static final String[] COLUMN_NAMES = new String[]{"getCatalogName", "getColumnClassName", "getColumnDisplaySize", "getColumnLabel", "getColumnName", "getColumnType", "getColumnTypeName", "getPrecision", "getScale", "getSchemaName", "getTableName", "isAutoIncrement", "isCaseSensitive", "isCurrency", "isDefinitelyWritable", "isNullable", "isReadOnly", "isSearchable", "isSigned", "isWritable"};
    private static final int[] COLUMN_TYPES = new int[]{12, 12, 4, 12, 12, 4, 12, 4, 4, 12, 12, 16, 16, 16, 16, 4, 16, 16, 16, 16};
    private Method[] _methods;
    private ResultSetMetaData _rsmd;
    private int _rowCount;
    private int _currentRow;
    private Integer _currentRowNumber;

    public static ResultSet getResultSetMetaData(String string) throws Exception {
        return new RSMDWrapper(DriverManager.getConnection("jdbc:default:connection"), string);
    }

    public RSMDWrapper(Connection connection, String string) throws Exception {
        super(COLUMN_NAMES);
        this.loadMethods();
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        this._rsmd = resultSet.getMetaData();
        this._rowCount = this._rsmd.getColumnCount();
        this._currentRow = 0;
        resultSet.close();
        preparedStatement.close();
    }

    private void loadMethods() throws Exception {
        int n = COLUMN_NAMES.length;
        this._methods = new Method[n];
        for (int i = 0; i < n; ++i) {
            this._methods[i] = ResultSetMetaData.class.getMethod(COLUMN_NAMES[i], Integer.TYPE);
        }
    }

    public boolean next() throws SQLException {
        if (this._currentRow >= this._rowCount) {
            return false;
        }
        ++this._currentRow;
        this._currentRowNumber = this._currentRow;
        return true;
    }

    public void close() {
        this._rsmd = null;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    protected String getRawColumn(int n) throws SQLException {
        int n2 = n - 1;
        Method method = this._methods[n2];
        Object object = null;
        try {
            object = method.invoke((Object)this._rsmd, this._currentRowNumber);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Could not invoke method '" + method + "'");
        }
        int n3 = COLUMN_TYPES[n2];
        switch (n3) {
            case 12: {
                return (String)object;
            }
            case 4: {
                return ((Integer)object).toString();
            }
            case 16: {
                return ((Boolean)object).toString();
            }
        }
        throw new SQLException("Unknown data type: " + n3);
    }
}

