/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class ClassLoaderBootTest
extends BaseJDBCTestCase {
    private static URL derbyClassLocation = ClassLoaderBootTest.getClassLocation("org.apache.derby.database.Database");
    private static URL embeddedDataSourceClassLocation = ClassLoaderBootTest.getClassLocation("org.apache.derby.jdbc.EmbeddedDataSource");
    private ClassLoader loader_1;
    private ClassLoader loader_2;
    private ClassLoader mainLoader;

    private static URL getClassLocation(String string) {
        CodeSource codeSource;
        try {
            Class<?> clazz = Class.forName(string);
            codeSource = clazz.getProtectionDomain().getCodeSource();
        }
        catch (ClassNotFoundException classNotFoundException) {
            codeSource = null;
        }
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }

    public ClassLoaderBootTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite;
        BaseTestSuite baseTestSuite2 = baseTestSuite = new BaseTestSuite(ClassLoaderBootTest.class);
        TestSetup testSetup = new CleanDatabaseTestSetup((Test)baseTestSuite2){

            @Override
            protected void setUp() throws Exception {
                super.setUp();
                DataSource dataSource = JDBCDataSource.getDataSource();
                JDBCDataSource.shutdownDatabase(dataSource);
            }
        };
        Properties properties = new Properties();
        properties.setProperty("derby.infolog.append", "true");
        testSetup = new SystemPropertyTestSetup((Test)testSetup, properties);
        return testSetup;
    }

    protected void setUp() throws Exception {
        URL[] uRLArray = new URL[]{derbyClassLocation, embeddedDataSourceClassLocation};
        this.mainLoader = this.getThreadLoader();
        this.loader_1 = this.createDerbyClassLoader(uRLArray);
        this.loader_2 = this.createDerbyClassLoader(uRLArray);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.mainLoader != null) {
            this.setThreadLoader(this.mainLoader);
        }
        this.loader_1 = null;
        this.loader_2 = null;
        this.mainLoader = null;
    }

    private DerbyURLClassLoader createDerbyClassLoader(URL[] uRLArray) throws Exception {
        return new DerbyURLClassLoader(this, uRLArray);
    }

    public void testBootingAnAlreadyBootedDatabase() throws SQLException {
        if (!JDBC.vmSupportsJDBC4()) {
            ClassLoaderBootTest.println("The dual boot test only runs on Java 6 and higher.");
            return;
        }
        ClassLoaderBootTest.println("The dual boot test is running.");
        this.setThreadLoader(this.loader_1);
        DataSource dataSource = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)this.getThreadLoader());
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)dataSource.getClass().getClassLoader());
        Connection connection = dataSource.getConnection();
        this.setThreadLoader(this.loader_2);
        DataSource dataSource2 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)this.getThreadLoader());
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)dataSource2.getClass().getClassLoader());
        try {
            dataSource2.getConnection();
            ClassLoaderBootTest.fail((String)"booted database that was already booted by another CLR");
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException.getNextException();
            ClassLoaderBootTest.assertPreventDualBoot(sQLException2);
            JDBCDataSource.shutEngine(dataSource2);
        }
        this.setThreadLoader(this.loader_1);
        JDBCDataSource.shutEngine(dataSource);
    }

    public void testBootingDatabaseShutdownByAnotherCLR() throws SQLException {
        this.setThreadLoader(this.loader_1);
        DataSource dataSource = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)dataSource.getClass().getClassLoader());
        Connection connection = dataSource.getConnection();
        JDBCDataSource.shutdownDatabase(dataSource);
        this.setThreadLoader(this.loader_2);
        DataSource dataSource2 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)dataSource2.getClass().getClassLoader());
        dataSource2.getConnection();
        JDBCDataSource.shutEngine(dataSource2);
        JDBCDataSource.shutEngine(dataSource);
    }

    private void setThreadLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader getThreadLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static void assertPreventDualBoot(SQLException sQLException) {
        ClassLoaderBootTest.assertNotNull((Object)sQLException);
        String string = sQLException.getSQLState();
        ClassLoaderBootTest.assertTrue((String)("Unexpected SQLState:" + string), (boolean)string.equals("XSDB6"));
    }

    public class DerbyURLClassLoader
    extends URLClassLoader {
        public DerbyURLClassLoader(ClassLoaderBootTest classLoaderBootTest, URL[] uRLArray) {
            super(uRLArray);
        }

        public DerbyURLClassLoader(ClassLoaderBootTest classLoaderBootTest, URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public DerbyURLClassLoader(ClassLoaderBootTest classLoaderBootTest, URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
            super(uRLArray, classLoader, uRLStreamHandlerFactory);
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null && !string.startsWith("org.apache.derby")) {
                clazz = this.getParent().loadClass(string);
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            }
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, false);
        }
    }
}

