/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_QualifierTest;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_Heap
extends T_Generic {
    private static final String testService = "heapTest";

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        AccessFactory accessFactory = null;
        TransactionController transactionController = null;
        boolean bl = false;
        this.out.println("executing heap test");
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            accessFactory = (AccessFactory)T_Heap.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (accessFactory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing heapTest");
        try {
            transactionController = accessFactory.getTransaction(T_Heap.getContextService().getCurrentContextManager());
            if (this.t_001(transactionController)) {
                bl = true;
            }
            transactionController.commit();
            transactionController.destroy();
        }
        catch (StandardException standardException) {
            System.out.println("got an exception.");
            String string = standardException.getMessage();
            if (string == null) {
                string = ((Object)((Object)standardException)).getClass().getName();
            }
            this.REPORT(string);
            throw T_Fail.exceptionFail(standardException);
        }
        if (!bl) {
            throw T_Fail.testFailMsg("T_Heap test failed");
        }
    }

    protected boolean t_001(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_001");
        T_QualifierTest t_QualifierTest = new T_QualifierTest("heap", null, false, this.out, 3);
        boolean bl = t_QualifierTest.t_testqual(transactionController);
        if (!bl) {
            throw T_Fail.testFailMsg("T_Heap.t_001 failed");
        }
        this.REPORT("Ending t_001");
        return bl;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

