/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.largedata.BlobImplT;
import org.apache.derbyTesting.functionTests.tests.largedata.ClobImplT;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomByteStreamT;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomCharReaderT;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobLimitsTest
extends BaseJDBCTestCase {
    static boolean trace = false;
    static final int _2GB = Integer.MAX_VALUE;
    static final int _100MB = 0x6400000;
    static final long _4GB = 0x100000000L;
    static final int NUM_TRAILING_SPACES = 33792;
    static int BIGGEST_LOB_SZ = Integer.MAX_VALUE;
    static int BIG_LOB_SZ = 0x6400000;
    static int MORE_DATA_THAN_COL_WIDTH = 104857601;
    static final String DATAFILE = "extinout/byteLobLimits.dat";
    static final String CHARDATAFILE = "extinout/charLobLimits.txt";

    public LobLimitsTest(String name) {
        super(name);
    }

    public static void setBIGGEST_LOB_SZ(int bIGGESTLOBSZ) {
        BIGGEST_LOB_SZ = bIGGESTLOBSZ;
    }

    public static void setBIG_LOB_SZ(int bIGLOBSZ) {
        BIG_LOB_SZ = bIGLOBSZ;
    }

    public static void setMORE_DATA_THAN_COL_WIDTH(int mOREDATATHANCOLWIDTH) {
        MORE_DATA_THAN_COL_WIDTH = mOREDATATHANCOLWIDTH;
    }

    static void setupTables(Statement s, int biggestlobsz, int biglobsz) throws SQLException {
        LobLimitsTest.setBIGGEST_LOB_SZ(biggestlobsz);
        LobLimitsTest.setBIG_LOB_SZ(biglobsz);
        LobLimitsTest.setMORE_DATA_THAN_COL_WIDTH(biglobsz + 1);
        LobLimitsTest.println("BIGGEST_LOB_SZ=" + BIGGEST_LOB_SZ + " BIG_LOB_SZ=" + BIG_LOB_SZ);
        s.execute("CREATE TABLE BLOBTBL (ID INT NOT NULL PRIMARY KEY, POS BIGINT, DLEN BIGINT, CONTENT BLOB(2G))");
        s.execute("CREATE TABLE CLOBTBL (ID INT NOT NULL PRIMARY KEY,POS BIGINT, DLEN BIGINT, CONTENT CLOB(2G))");
        s.execute("CREATE TABLE BLOBTBL2 (ID INT NOT NULL PRIMARY KEY, POS BIGINT, CONTENT BLOB(" + BIG_LOB_SZ + "),DLEN BIGINT)");
        s.execute("CREATE TABLE CLOBTBL2 (ID INT NOT NULL PRIMARY KEY,POS BIGINT, CONTENT CLOB(" + BIG_LOB_SZ + "), DLEN BIGINT)");
    }

    public static Test suite() {
        return LobLimitsTest.baseSuite(Integer.MAX_VALUE, 0x6400000);
    }

    static Test baseSuite(final int biggestSize, final int bigSize) {
        Properties sysprops = new Properties();
        sysprops.setProperty("derby.locks.deadlockTrace", "true");
        sysprops.setProperty("derby.locks.monitor", "true");
        TestSetup suite = new CleanDatabaseTestSetup((Test)new BaseTestSuite(LobLimitsTest.class)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                LobLimitsTest.setupTables(s, biggestSize, bigSize);
            }
        };
        suite = new SystemPropertyTestSetup((Test)suite, sysprops);
        return new SupportFilesSetup((Test)suite);
    }

    public void test_01_Blob() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement insertBlob = this.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        PreparedStatement selectBlob = this.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL WHERE ID = ?");
        PreparedStatement insertBlob2 = this.prepareStatement("INSERT INTO BLOBTBL2 values (?,?,?,?)");
        PreparedStatement selectBlob2 = this.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL2 WHERE ID = ?");
        this.insertBlob_SetBinaryStream("BlobTest #1", insertBlob, BIGGEST_LOB_SZ, 0, 2, BIGGEST_LOB_SZ);
        this.selectBlob("BlobTest #2", selectBlob, BIGGEST_LOB_SZ, 0, 1);
        this.selectBlob("BlobTest #3", selectBlob, BIGGEST_LOB_SZ, 1, 1);
        this.selectUpdateBlob("BlobTest #4", selectBlob, BIGGEST_LOB_SZ, 0, 1);
        this.selectInsertBlob("BlobTest #4.1", selectBlob, insertBlob, BIGGEST_LOB_SZ, 0, 3);
        FileOutputStream fos = PrivilegedFileOpsForTests.getFileOutputStream(new File(DATAFILE));
        RandomByteStreamT r = new RandomByteStreamT(new Random(), BIG_LOB_SZ);
        byte[] buffer = new byte[32768];
        int count = 0;
        while ((count = r.read(buffer)) >= 0) {
            fos.write(buffer, 0, count);
        }
        fos.flush();
        fos.close();
        this.insertBlob2("BlobTest #5.1 ", insertBlob2, BIG_LOB_SZ, 0, 1, BIG_LOB_SZ, DATAFILE);
        this.selectBlob2("BlobTest #5.2 ", selectBlob2, BIG_LOB_SZ, 0, 1, DATAFILE);
        this.selectUpdateBlob2("BlobTest #6", selectBlob2, selectBlob, BIG_LOB_SZ, 0, 1, DATAFILE);
        this.deleteAndTruncateTable("BLOBTBL2", 1);
        this.commit();
        this.deleteAndTruncateTable("BLOBTBL", 3);
    }

    public void test_02_BlobNegative() throws SQLException {
        this.setAutoCommit(false);
        PreparedStatement insertBlob = this.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        BlobImplT _4GbBlob = new BlobImplT(new RandomByteStreamT(new Random(), 0x100000000L), 0x100000000L);
        try {
            this.insertBlob_SetBlob("BlobTest #7 (setBlob with 4Gb blob", insertBlob, _4GbBlob, 0x100000000L, 0, 1, 0);
            LobLimitsTest.fail((String)"Inserting 4BG blob should have thrown exception");
        }
        catch (SQLException sqle) {
            if (LobLimitsTest.usingDerbyNetClient()) {
                LobLimitsTest.assertSQLState("XN015", sqle);
            } else {
                LobLimitsTest.assertSQLState("22003", sqle);
            }
            this.commit();
        }
    }

    public void test_03_Clob1() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement insertClob = this.prepareStatement("INSERT INTO CLOBTBL values (?,?,?,?)");
        PreparedStatement selectClob = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        this.insertClob_SetCharacterStream("ClobTest #1", insertClob, BIGGEST_LOB_SZ, 0, 2, BIGGEST_LOB_SZ);
        this.selectClob("ClobTest #2", selectClob, BIGGEST_LOB_SZ, 0, 1);
        this.selectClob("ClobTest #3", selectClob, BIGGEST_LOB_SZ, 0, 1);
        this.selectUpdateClob("ClobTest #4", selectClob, BIGGEST_LOB_SZ, 0, 1);
    }

    public void test_04_Clob2() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement selectClob = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        PreparedStatement insertClob2 = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        PreparedStatement selectClob2 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 WHERE ID = ?");
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), BIG_LOB_SZ));
        this.insertClob2("ClobTest #5.1 ", insertClob2, BIG_LOB_SZ, 0, 1, BIG_LOB_SZ, CHARDATAFILE);
        this.selectClob2("ClobTest #5.2 ", selectClob2, BIG_LOB_SZ, 0, 1, CHARDATAFILE);
        if (!LobLimitsTest.usingEmbedded() || BIGGEST_LOB_SZ != Integer.MAX_VALUE) {
            this.updateClob2("ClobTest #8.1", selectClob, BIG_LOB_SZ, 0, 0, 10, CHARDATAFILE);
        }
        this.selectUpdateClob2("ClobTest #8.2", selectClob2, selectClob, BIG_LOB_SZ, 0, 1, CHARDATAFILE);
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), 33792 + BIG_LOB_SZ, 33792L));
        this.insertClob2("ClobTest #6.1 ", insertClob2, BIG_LOB_SZ, 3, 1, 33792 + BIG_LOB_SZ, CHARDATAFILE);
        this.selectClob2("ClobTest #6.2 ", selectClob2, BIG_LOB_SZ, 3, 1, CHARDATAFILE);
    }

    public void test_05_ClobNegative() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement insertClob = this.prepareStatement("INSERT INTO CLOBTBL values (?,?,?,?)");
        PreparedStatement selectClob = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        PreparedStatement insertClob2 = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        PreparedStatement selectClob2 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 WHERE ID = ?");
        this.negativeSpaceTruncationTest("ClobTest #7");
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), MORE_DATA_THAN_COL_WIDTH));
        if (!LobLimitsTest.usingDerbyNetClient()) {
            try {
                this.insertClob2("ClobTest #9.1 ", insertClob2, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH, CHARDATAFILE);
                LobLimitsTest.fail((String)"ClobTest #9.1 should have thrown XSDA4");
            }
            catch (SQLException sqle) {
                LobLimitsTest.assertSQLState("XSDA4", sqle);
            }
        }
        this.selectClob2("ClobTest #9.2 ", selectClob2, BIG_LOB_SZ, 4, 0, CHARDATAFILE);
        try {
            this.insertClob2("ClobTest #10 ", insertClob2, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH + 1, CHARDATAFILE);
            LobLimitsTest.fail((String)"ClobTest #10. Should have thrown XSDA4");
        }
        catch (SQLException sqle) {
            LobLimitsTest.assertSQLState("XSDA4", sqle);
        }
        try {
            this.insertClob2("ClobTest #11 ", insertClob2, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH - 1, CHARDATAFILE);
            LobLimitsTest.fail((String)"ClobTest #11. Should have thrown XSDA4");
        }
        catch (SQLException sqle) {
            LobLimitsTest.assertSQLState("XSDA4", sqle);
        }
        this.deleteAndTruncateTable("CLOBTBL2", 2);
        try {
            this.insertClob_SetCharacterStream("ClobTest #12.1", insertClob, BIG_LOB_SZ, 4, 1, -1);
            LobLimitsTest.fail((String)"ClobTest #12. Should have thrown XJ025");
        }
        catch (SQLException sqle) {
            LobLimitsTest.assertSQLState("XJ025", sqle);
        }
        this.selectClob("ClobTest #12.2", selectClob, BIG_LOB_SZ, 4, 0);
        this.deleteAndTruncateTable("CLOBTBL", 2);
        ClobImplT _4GBClob = new ClobImplT(new RandomCharReaderT(new Random(), 0x100000000L), 0x100000000L);
        try {
            this.insertClob_SetClob("ClobTest #13 (setClob with 4Gb clob", insertClob, _4GBClob, 0x100000000L, 0, 1, 0);
            LobLimitsTest.fail((String)"ClobTest #13. Should have thrown 22033");
        }
        catch (SQLException sqle) {
            if (LobLimitsTest.usingDerbyNetClient()) {
                LobLimitsTest.assertSQLState("XN015", sqle);
            }
            LobLimitsTest.assertSQLState("22003", sqle);
        }
        this.rollback();
    }

    public void test_06_shutdownDB() throws Exception {
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    private void negativeSpaceTruncationTest(String msg) throws Exception {
        PreparedStatement insertClob2 = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        try {
            this.insertClob2(msg, insertClob2, BIG_LOB_SZ, 4, 1, 33792 + BIG_LOB_SZ - 1, CHARDATAFILE);
            LobLimitsTest.fail((String)(msg + ". Should have thrown XSDA4"));
        }
        catch (SQLException sqle) {
            LobLimitsTest.assertSQLState("XSDA4", sqle);
        }
        try {
            this.insertClob2(msg, insertClob2, BIG_LOB_SZ, 5, 1, 33792 + BIG_LOB_SZ + 1, CHARDATAFILE);
            LobLimitsTest.fail((String)(msg + ". Should have thrown XSDA4"));
        }
        catch (SQLException sqle) {
            LobLimitsTest.assertSQLState("XSDA4", sqle);
        }
    }

    private void insertBlob_SetBinaryStream(String testId, PreparedStatement ps, int bloblen, int start, int rows, int streamLength) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "insertBlob of size = " + bloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        Random random = new Random();
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, bloblen);
            ps.setBinaryStream(4, (InputStream)new RandomByteStreamT(random, bloblen), streamLength);
            count += ps.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + bloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, rows, " Rows inserted with blob of size (" + bloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    private void insertBlob_SetBlob(String testId, PreparedStatement ps, Blob blob, long bloblen, int start, int rows, int expectedRows) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "insertBlob of size = " + bloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, bloblen);
            ps.setBlob(4, blob);
            count += ps.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + bloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, expectedRows, " Rows inserted with blob of size (" + bloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectBlob(String testId, PreparedStatement ps, int bloblen, int id, int expectedRows) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - SELECT BLOB of size = " + bloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Blob value = rs.getBlob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id), (long)dlen, (long)l);
        }
        rs.close();
        this.commit();
        LobLimitsTest.verifyTest(count, expectedRows, "Matched rows selected with blob of size(" + bloblen + ") =");
        LobLimitsTest.println("Select Blob (" + bloblen + ") rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.println("========================================");
    }

    private void insertBlob2(String testId, PreparedStatement ps, int bloblen, int start, int rows, int streamLength, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "insert Blob of size = " + bloblen);
        int count = 0;
        long ST = System.currentTimeMillis();
        for (int i = start; i < start + rows; ++i) {
            FileInputStream fis = PrivilegedFileOpsForTests.getFileInputStream(new File(file));
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(4, bloblen);
            ps.setBinaryStream(3, (InputStream)fis, streamLength);
            count += ps.executeUpdate();
            fis.close();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + bloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, rows, " Rows inserted with blob of size (" + bloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectBlob2(String testId, PreparedStatement ps, int bloblen, int id, int expectedRows, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - SELECT BLOB of size = " + bloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Blob value = rs.getBlob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id), (long)dlen, (long)l);
            LobLimitsTest.compareBlobToFile(value.getBinaryStream(), file);
        }
        rs.close();
        this.commit();
        LobLimitsTest.verifyTest(count, expectedRows, "Matched rows selected with blob of size(" + bloblen + ") =");
        LobLimitsTest.println("Select Blob (" + bloblen + ") rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateBlob(String testId, PreparedStatement ps, int bloblen, int id, int updateId) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then update blob of size= " + bloblen + " - Uses getBlob api");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id), (long)dlen, (long)l);
        PreparedStatement psUpd = this.prepareStatement("update BLOBTBL set content=?,dlen =?where id = ?");
        psUpd.setBlob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        LobLimitsTest.println("Rows Updated = " + psUpd.executeUpdate());
        this.commit();
        ps.setInt(1, updateId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Blob updatedValue = rs2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + updatedValue.length()), (long)l, (long)updatedValue.length());
        this.commit();
        rs.close();
        rs2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectInsertBlob(String testId, PreparedStatement ps, PreparedStatement ins, int bloblen, int id, int insertId) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then insert blob of size= " + bloblen + " - Uses getBlob api to do select and setBlob for insert");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id), (long)dlen, (long)l);
        ins.setInt(1, insertId);
        ins.setInt(2, 0);
        ins.setLong(3, l);
        ins.setBlob(4, value);
        LobLimitsTest.assertUpdateCount(ins, 1);
        this.commit();
        ps.setInt(1, insertId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Blob insertedValue = rs2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + insertedValue.length()), (long)l, (long)insertedValue.length());
        this.commit();
        rs.close();
        rs2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateBlob2(String testId, PreparedStatement ps, PreparedStatement sel, int bloblen, int id, int updateId, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then update blob of size= " + bloblen + " - Uses getBlob and setBlob  api");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL2 with ID=" + id), (long)dlen, (long)l);
        PreparedStatement psUpd = this.prepareStatement("update BLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setBlob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        LobLimitsTest.assertUpdateCount(psUpd, 1);
        this.commit();
        sel.setInt(1, updateId);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Blob updatedValue = rs2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated blob value : expected=" + l + " found =" + updatedValue.length()), (long)l, (long)updatedValue.length());
        LobLimitsTest.compareBlobToFile(updatedValue.getBinaryStream(), file);
        this.commit();
        rs.close();
        rs2.close();
        LobLimitsTest.println("========================================");
    }

    private static void compareBlobToFile(InputStream lobstream, String filename) throws Exception {
        FileInputStream file = PrivilegedFileOpsForTests.getFileInputStream(new File(filename));
        LobLimitsTest.assertEquals(file, lobstream);
    }

    private void deleteAndTruncateTable(String table, int expectedRows) throws SQLException {
        Statement s = this.createStatement();
        int count = s.executeUpdate("DELETE FROM " + JDBC.escape(table));
        s.executeUpdate("TRUNCATE TABLE " + JDBC.escape(table));
        this.commit();
        LobLimitsTest.verifyTest(count, expectedRows, "Rows deleted =");
    }

    private void insertClob_SetCharacterStream(String testId, PreparedStatement ps, int cloblen, int start, int rows, int streamLength) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "  -insertClob of size = " + cloblen);
        Random random = new Random();
        int count = 0;
        long ST = System.currentTimeMillis();
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, cloblen);
            ps.setCharacterStream(4, (Reader)new RandomCharReaderT(random, cloblen), streamLength);
            count += ps.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + cloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, rows, "Rows inserted with clob of size (" + cloblen + ") = ");
        LobLimitsTest.println("========================================");
    }

    private void insertClob_SetClob(String testId, PreparedStatement ps, Clob clob, long cloblen, int start, int rows, int expectedRows) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "insertClob of size = " + cloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, cloblen);
            ps.setClob(4, clob);
            count += ps.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + cloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, expectedRows, " Rows inserted with clob of size (" + cloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectClob(String testId, PreparedStatement ps, int cloblen, int id, int expectedRows) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - SELECT CLOB of size = " + cloblen);
        int count = 0;
        long ST = System.currentTimeMillis();
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Clob value = rs.getClob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL with ID=" + id), (long)l, (long)dlen);
        }
        rs.close();
        this.commit();
        LobLimitsTest.println("Select Clob (" + cloblen + ") rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, expectedRows, "Matched rows selected with clob of size(" + cloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClob2(String testId, PreparedStatement ps, int cloblen, int start, int rows, int streamLength, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + "insert Clob of size = " + cloblen);
        int count = 0;
        long ST = System.currentTimeMillis();
        for (int i = start; i < start + rows; ++i) {
            FileReader reader = PrivilegedFileOpsForTests.getFileReader(new File(file));
            try {
                LobLimitsTest.println("Got reader for file " + file + " " + String.valueOf(reader));
                ps.setInt(1, i);
                ps.setInt(2, 0);
                ps.setLong(4, cloblen);
                ps.setCharacterStream(3, (Reader)reader, streamLength);
                count += ps.executeUpdate();
                continue;
            }
            finally {
                reader.close();
                LobLimitsTest.println("Closed reader for file " + file + " " + String.valueOf(reader));
            }
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + cloblen + ") rows= " + count + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.verifyTest(count, rows, " Rows inserted with clob of size (" + cloblen + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectClob2(String testId, PreparedStatement ps, int cloblen, int id, int expectedRows, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - SELECT CLOB of size = " + cloblen);
        long ST = System.currentTimeMillis();
        int count = 0;
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Clob value = rs.getClob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id), (long)l, (long)cloblen);
            LobLimitsTest.compareClobToFile(value.getCharacterStream(), file, cloblen);
        }
        rs.close();
        this.commit();
        LobLimitsTest.verifyTest(count, expectedRows, "Matched rows selected with clob of size(" + cloblen + ") =");
        LobLimitsTest.println("Select Clob (" + cloblen + ") rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateClob(String testId, PreparedStatement ps, int cloblen, int id, int updateId) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses setClob api");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL with ID=" + id), (long)dlen, (long)l);
        PreparedStatement psUpd = this.prepareStatement("update CLOBTBL set content=?, dlen =? where id = ?");
        psUpd.setCharacterStream(1, value.getCharacterStream(), (int)l);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        if (LobLimitsTest.usingDerbyNetClient()) {
            LobLimitsTest.assertPreparedStatementError("XN023", psUpd);
            return;
        }
        LobLimitsTest.assertUpdateCount(psUpd, 1);
        this.commit();
        ps.setInt(1, updateId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated clob length does not match expected length = " + l + " found = " + updatedValue.length()), (long)l, (long)updatedValue.length());
        this.commit();
        rs.close();
        rs2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateClob2(String testId, PreparedStatement ps, PreparedStatement sel, int cloblen, int id, int updateId, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses setClob api");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id), (long)dlen, (long)l);
        PreparedStatement psUpd = this.prepareStatement("update CLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setClob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        LobLimitsTest.assertUpdateCount(psUpd, 1);
        this.commit();
        sel.setInt(1, updateId);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated clob value , found=" + updatedValue.length() + ",expected = " + l), (long)l, (long)updatedValue.length());
        LobLimitsTest.compareClobToFile(updatedValue.getCharacterStream(), file, (int)l);
        this.commit();
        rs.close();
        rs2.close();
        LobLimitsTest.println("========================================");
    }

    private void updateClob2(String testId, PreparedStatement sel, int cloblen, int id, int updateRowId, int updateIdVal, String file) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses updateClob api");
        PreparedStatement ps1 = this.prepareStatement("SELECT * FROM CLOBTBL FOR UPDATE", 1003, 1008);
        PreparedStatement ps = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 where ID =?");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            LobLimitsTest.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id);
        }
        ResultSet rs1 = ps1.executeQuery();
        while (rs1.next()) {
            if (rs1.getInt(1) != updateRowId) continue;
            rs1.updateClob(4, value);
            rs1.updateInt(1, updateIdVal);
            rs1.updateInt(2, 0);
            rs1.updateLong(3, dlen);
            rs1.updateRow();
            break;
        }
        this.commit();
        rs.close();
        rs1.close();
        sel.setInt(1, updateIdVal);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated clob value ,found=" + updatedValue.length() + ",expected = " + l), (long)l, (long)updatedValue.length());
        LobLimitsTest.compareClobToFile(updatedValue.getCharacterStream(), file, (int)l);
        if (updatedValue.length() != l) {
            LobLimitsTest.println("FAIL - MISMATCH length of updated clob value ,found=" + updatedValue.length() + ",expected = " + l);
        } else {
            LobLimitsTest.compareClobToFile(updatedValue.getCharacterStream(), file, (int)l);
        }
        LobLimitsTest.println("========================================");
    }

    private static void compareClobToFile(Reader lobstream, String filename, int length) throws Exception {
        FileReader file = PrivilegedFileOpsForTests.getFileReader(new File(filename));
        int c1 = 0;
        int c2 = 0;
        long count = 0L;
        do {
            c1 = lobstream.read();
            c2 = file.read();
            LobLimitsTest.assertEquals((String)("FAIL -- MISMATCH in data stored versus data retrieved at " + count + " " + c1 + " does not match " + c2), (int)c2, (int)c1);
            ++count;
        } while (c1 != -1 && c2 != -1 && --length > 0);
        file.close();
    }

    private static void verifyTest(int affectedRows, int expectedRows, String test) {
        LobLimitsTest.assertEquals((String)("FAIL --" + test + affectedRows + " , but expected rows =" + expectedRows), (int)expectedRows, (int)affectedRows);
        LobLimitsTest.println(test + affectedRows);
    }

    private static void writeToFile(String file, Reader r) throws IOException {
        File f = new File(file);
        if (PrivilegedFileOpsForTests.exists(f)) {
            LobLimitsTest.assertTrue((boolean)PrivilegedFileOpsForTests.delete(f));
        }
        FileWriter writer = PrivilegedFileOpsForTests.getFileWriter(f);
        LobLimitsTest.println("Got FileWriter for " + file + " " + String.valueOf(writer));
        char[] buffer = new char[32768];
        int count = 0;
        while ((count = r.read(buffer)) >= 0) {
            writer.write(buffer, 0, count);
        }
        writer.flush();
        writer.close();
        LobLimitsTest.println("writer " + String.valueOf(writer) + " for file " + file + " closed");
    }
}

