/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.util.Random;

public class UniqueRandomSequence {
    private final int[] numbers;
    private final Random random = new Random();
    private int numbersLeft;

    public UniqueRandomSequence(int length) {
        this(0, length, 1);
    }

    public UniqueRandomSequence(int start, int length, int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("step must be greater than 0");
        }
        this.numbers = new int[length];
        int i = 0;
        int val = start;
        while (i < length) {
            this.numbers[i] = val;
            ++i;
            val += step;
        }
        this.numbersLeft = length;
    }

    public boolean hasMore() {
        return this.numbersLeft > 0;
    }

    public int nextValue() {
        int pos = this.random.nextInt(this.numbersLeft);
        int value = this.numbers[pos];
        this.numbers[pos] = this.numbers[this.numbersLeft - 1];
        --this.numbersLeft;
        return value;
    }
}

