/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.CanonTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.LocaleTestSetup;

public abstract class ScriptTestCase
extends CanonTestCase {
    private final String inputEncoding;
    private final String user;
    private boolean useSystemProperties = false;
    private Locale oldLocale;

    public ScriptTestCase(String string, boolean bl) {
        this(string, null, null, null);
        this.useSystemProperties = bl;
    }

    public ScriptTestCase(String string) {
        this(string, null, null, null);
    }

    public ScriptTestCase(String string, String string2) {
        this(string, string2, string2, null);
    }

    public ScriptTestCase(String string, String string2, String string3, String string4) {
        super(string, string3);
        ScriptTestCase.setSystemProperty("ij.showNoConnectionsAtStart", "true");
        ScriptTestCase.setSystemProperty("ij.showNoCountForSelect", "true");
        this.inputEncoding = string2 == null ? "US-ASCII" : string2;
        this.user = string4;
    }

    protected String getArea() {
        String string = ((Object)((Object)this)).getClass().getName();
        int n = string.lastIndexOf(46);
        string = string.substring(0, n);
        n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    public static Test getIJConfig(Test test) {
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        return test;
    }

    public void runTest() throws Throwable {
        String string;
        String string2 = "org/apache/derbyTesting/functionTests/tests/" + this.getArea() + "/" + this.getName() + ".sql";
        String string3 = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        URL uRL = ScriptTestCase.getTestResource(string2);
        ScriptTestCase.assertNotNull((String)("SQL script missing: " + string2), (Object)uRL);
        InputStream inputStream = ScriptTestCase.openTestResource(uRL);
        Connection connection = this.user != null ? this.openUserConnection(this.user) : this.getConnection();
        String string4 = ScriptTestCase.getSystemProperty("derby.ui.codeset");
        if (string4 != null) {
            string = null;
            ScriptTestCase.assertEquals((String)"Requested output encoding and derby.ui.codeset differ", (String)this.outputEncoding, (String)string4);
        } else {
            string = this.outputEncoding;
        }
        ij.runScript((Connection)connection, (InputStream)inputStream, (String)this.inputEncoding, (OutputStream)this.getOutputStream(), (String)string, (boolean)this.useSystemProperties);
        if (!connection.isClosed() && !connection.getAutoCommit()) {
            connection.commit();
        }
        inputStream.close();
        this.compareCanon(string3);
    }

    protected void setUp() {
        this.oldLocale = Locale.getDefault();
        LocaleTestSetup.setDefaultLocale(Locale.US);
        LocalizedResource.resetLocalizedResourceCache();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        LocaleTestSetup.setDefaultLocale(this.oldLocale);
        LocalizedResource.resetLocalizedResourceCache();
    }
}

