/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.platform.PlatformDefaultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformFactory {
    private static HashMap<String, Platform> platforms = new HashMap();
    private static Log log = LogFactory.getLog(PlatformFactory.class);

    private PlatformFactory() {
    }

    public static Platform getPlatformFor(String dbms) {
        Platform result = null;
        String platformName = null;
        result = PlatformFactory.getPlatforms().get(dbms);
        if (result == null) {
            try {
                platformName = PlatformFactory.getClassnameFor(dbms);
                Class<?> platformClass = Class.forName(platformName);
                result = (Platform)platformClass.newInstance();
            }
            catch (Throwable t) {
                log.warn((Object)("problems with platform " + platformName + ": " + t.getMessage()));
                log.warn((Object)"Torque will use PlatformDefaultImpl instead");
                result = new PlatformDefaultImpl();
            }
            PlatformFactory.getPlatforms().put(dbms, result);
        }
        return result;
    }

    private static String getClassnameFor(String platform) {
        String pf = "Default";
        if (platform != null) {
            pf = platform;
        }
        String myClassname = PlatformFactory.class.getName();
        String myPackage = myClassname.substring(0, myClassname.lastIndexOf("."));
        return myPackage + ".Platform" + pf.substring(0, 1).toUpperCase() + pf.substring(1) + "Impl";
    }

    private static HashMap<String, Platform> getPlatforms() {
        return platforms;
    }
}

