package org.apache.torque.util.functions;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;

/**
 * SQL99 Standard sum function.
 *
 * @version $Id: Sum.java 1448414 2013-02-20 21:06:35Z tfischer $
 */
public class Sum extends AggregateFunction
{
    /**
     * Construct an SUM function class with the column to sum over.
     *
     * @param column the Column to sum over.
     */
    public Sum(Column column)
    {
        super("SUM", column, false);
    }

    /**
     * Construct an SUM function class with an SQL expression to sum over.
     *
     * @param sqlExpression the SQL expression to sum over.
     */
    public Sum(String sqlExpression)
    {
        super("SUM", new ColumnImpl(sqlExpression), false);
    }

    /**
     * Construct an SUM function class with the column to sum over
     * and possibly a distinct modifier.
     *
     * @param column the Column to sum over.
     * @param distinct whether to count only over distinct values.
     */
    public Sum(Column column, boolean distinct)
    {
        super("SUM", column, distinct);
    }

    /**
     * This method cannot be called, an UnsupportedOperationException
     * will always be thrown.
     *
     * @param function disregarded.
     *
     * @throws UnsupportedOperationException always.
     */
    @Override
    public void setFunction(String function)
    {
        throw new UnsupportedOperationException(
                "The function name may not be changed.");
    }
}
