/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.torque.generator.configuration.source.EntityReferences;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.apache.torque.generator.source.stream.XmlSourceSaxHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlSourceFormat
implements StreamSourceFormat {
    private static final String KEY = "xml";
    private static final String FILENAME_EXTENSION = "xml";
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();

    @Override
    public String getKey() {
        return "xml";
    }

    @Override
    public String getFilenameExtension() {
        return "xml";
    }

    @Override
    public SourceElement parse(InputStream xmlStream, ControllerState controllerState) throws SourceException {
        if (xmlStream == null) {
            throw new NullPointerException("No Input path specified");
        }
        try {
            SAXParser parser = SAX_FACTORY.newSAXParser();
            EntityReferences entityReferences = controllerState.getUnitConfiguration().getEntityReferences();
            XmlSourceSaxHandler handler = new XmlSourceSaxHandler(entityReferences);
            parser.parse(xmlStream, (DefaultHandler)handler);
            return handler.getRoot();
        }
        catch (IOException e) {
            throw new SourceException("Error reading XML source file: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SourceException("Error parsing XML source file: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new SourceException("Parser configuration error parsing Properties source file: " + e.getMessage(), e);
        }
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(XmlSourceFormat.class);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        SAX_FACTORY.setNamespaceAware(true);
        try {
            SAX_FACTORY.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            SAX_FACTORY.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

