/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.monitoring;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.monitoring.MonitorResultEvent;

@RequestScoped
public class RequestInvocationCounter {
    @Inject
    private Event<MonitorResultEvent> mre;
    private Map<String, AtomicInteger> methodInvocations = new HashMap<String, AtomicInteger>();
    private Map<String, AtomicLong> methodDurations = new HashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> classInvocations = new HashMap<String, AtomicInteger>();

    @PreDestroy
    public void postUsage() {
        this.mre.fire((Object)new MonitorResultEvent(this.methodInvocations, this.classInvocations, this.methodDurations));
    }

    public void count(String className, String methodName, long duration) {
        AtomicInteger classCount = this.classInvocations.get(className);
        if (classCount == null) {
            classCount = new AtomicInteger(0);
            this.classInvocations.put(className, classCount);
        }
        classCount.incrementAndGet();
        String methodKey = className + "#" + methodName;
        AtomicInteger methCount = this.methodInvocations.get(methodKey);
        if (methCount == null) {
            methCount = new AtomicInteger(0);
            this.methodInvocations.put(methodKey, methCount);
        }
        methCount.incrementAndGet();
        AtomicLong methDur = this.methodDurations.get(methodKey);
        if (methDur == null) {
            methDur = new AtomicLong(0L);
            this.methodDurations.put(methodKey, methDur);
        }
        methDur.addAndGet(duration);
    }
}

