/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.injection.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.bean.BeanBuilder;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.apache.deltaspike.jsf.impl.injection.proxy.ConverterAndValidatorProxyFactory;
import org.apache.deltaspike.jsf.impl.injection.proxy.ConverterInvocationHandler;
import org.apache.deltaspike.jsf.impl.injection.proxy.ValidatorInvocationHandler;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyContextualLifecycle;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;

public class ConverterAndValidatorProxyExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ConverterAndValidatorProxyExtension.class.getName());
    private Boolean isActivated = true;
    private Set<Class<?>> classesToProxy = new HashSet();

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public <X> void findConverterAndValidatorsWhichNeedProxiesForDependencyInjectionSupport(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        Class beanClass = pat.getAnnotatedType().getJavaClass();
        if (!Converter.class.isAssignableFrom(beanClass) && !Validator.class.isAssignableFrom(beanClass)) {
            return;
        }
        Bean bean = new BeanBuilder(beanManager).readFromType(pat.getAnnotatedType()).create();
        if (!this.hasInjectionPoints(bean) && !this.hasNormalScopeAnnotation(bean, beanManager)) {
            pat.veto();
            return;
        }
        if (!this.hasPublicProperty(beanClass)) {
            return;
        }
        if (!Modifier.isFinal(beanClass.getModifiers())) {
            this.classesToProxy.add(beanClass);
            pat.veto();
        } else {
            LOG.warning("To use dependency-injection in converters/validators with properties, you they aren't allowed to be 'final'.");
        }
    }

    protected <X> boolean hasInjectionPoints(Bean<X> bean) {
        return !bean.getInjectionPoints().isEmpty();
    }

    protected <X> boolean hasNormalScopeAnnotation(Bean<X> bean, BeanManager beanManager) {
        Class scopeAnnotationClass = bean.getScope();
        return scopeAnnotationClass != null && beanManager.isNormalScope(scopeAnnotationClass);
    }

    protected <X> boolean hasPublicProperty(Class<X> beanClass) {
        for (Method currentMethod : beanClass.getMethods()) {
            if (!currentMethod.getName().startsWith("set") || currentMethod.getName().length() <= 3 || currentMethod.getParameterTypes().length != 1 || !this.hasGetterMethod(beanClass, currentMethod.getName().substring(3))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasGetterMethod(Class beanClass, String name) {
        try {
            if (beanClass.getMethod("get" + name, new Class[0]) != null || beanClass.getMethod("is" + name, new Class[0]) != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public <X> void createBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (Class<?> originalClass : this.classesToProxy) {
            Bean<?> bean = this.createBean(originalClass, beanManager);
            if (bean == null) continue;
            afterBeanDiscovery.addBean(bean);
        }
        this.classesToProxy.clear();
    }

    protected <T> Bean<T> createBean(Class<T> beanClass, BeanManager beanManager) {
        Class invocationHandlerClass = Converter.class.isAssignableFrom(beanClass) ? ConverterInvocationHandler.class : ValidatorInvocationHandler.class;
        AnnotatedType annotatedType = new AnnotatedTypeBuilder().readFromType(beanClass).create();
        DeltaSpikeProxyContextualLifecycle lifecycle = new DeltaSpikeProxyContextualLifecycle(beanClass, invocationHandlerClass, (DeltaSpikeProxyFactory)ConverterAndValidatorProxyFactory.getInstance(), beanManager);
        BeanBuilder beanBuilder = new BeanBuilder(beanManager).readFromType(annotatedType).passivationCapable(true).beanLifecycle((ContextualLifecycle)lifecycle);
        return beanBuilder.create();
    }
}

