/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.navigation;

import java.lang.reflect.Constructor;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.impl.navigation.DeltaSpikeNavigationHandler;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;

public class NavigationHandlerAwareApplication
extends ApplicationWrapper
implements Deactivatable {
    private static volatile Boolean manualNavigationHandlerWrapperMode;
    private static Class navigationHandlerWrapperClass;
    private final Application wrapped;

    public NavigationHandlerAwareApplication(Application wrapped) {
        this.wrapped = wrapped;
    }

    public NavigationHandler getNavigationHandler() {
        return this.wrapNavigationHandler(this.wrapped.getNavigationHandler());
    }

    private NavigationHandler wrapNavigationHandler(NavigationHandler handler) {
        NavigationHandler result = null;
        if (manualNavigationHandlerWrapperMode == null) {
            NavigationHandlerAwareApplication.lazyInit();
        }
        if (!manualNavigationHandlerWrapperMode.booleanValue()) {
            result = this.wrapNavigationHandlerWithNewWrapper(handler);
        }
        if (result != null) {
            return result;
        }
        return new DeltaSpikeNavigationHandler(handler);
    }

    private static synchronized void lazyInit() {
        if (manualNavigationHandlerWrapperMode != null) {
            return;
        }
        Class wrapperClass = ClassUtils.tryToLoadClassForName((String)"javax.faces.application.ConfigurableNavigationHandlerWrapper");
        if (wrapperClass != null) {
            navigationHandlerWrapperClass = ClassUtils.tryToLoadClassForName((String)"org.apache.deltaspike.jsf.impl.navigation.DeltaSpikeNavigationHandlerWrapper");
            if (navigationHandlerWrapperClass != null) {
                manualNavigationHandlerWrapperMode = false;
            } else {
                JsfUtils.logWrongModuleUsage(NavigationHandlerAwareApplication.class.getName());
                manualNavigationHandlerWrapperMode = true;
            }
        } else {
            manualNavigationHandlerWrapperMode = true;
        }
    }

    private NavigationHandler wrapNavigationHandlerWithNewWrapper(NavigationHandler handler) {
        if (ConfigurableNavigationHandler.class.isAssignableFrom(handler.getClass())) {
            try {
                Constructor deltaSpikeNavigationHandlerWrapperConstructor = navigationHandlerWrapperClass.getConstructor(ConfigurableNavigationHandler.class);
                NavigationHandler navigationHandlerWrapper = (NavigationHandler)deltaSpikeNavigationHandlerWrapperConstructor.newInstance(handler);
                return navigationHandlerWrapper;
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    public Application getWrapped() {
        return this.wrapped;
    }
}

