/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.resource;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.jsf.impl.resource.DeltaSpikeResource;

public class DeltaSpikeResourceHandler
extends ResourceHandlerWrapper
implements Deactivatable {
    private static final String LIBRARY = "deltaspike";
    private static final String LIBRARY_UNCOMPRESSED = "deltaspike-uncompressed";
    private final ResourceHandler wrapped;
    private final String version;
    private final boolean activated;

    public DeltaSpikeResourceHandler(ResourceHandler resourceHandler) {
        this.wrapped = resourceHandler;
        this.version = ClassUtils.getJarVersion(((Object)((Object)this)).getClass());
        this.activated = ClassDeactivationUtils.isActivated(((Object)((Object)this)).getClass());
    }

    public Resource createResource(String resourceName, String libraryName) {
        Object resource = this.wrapped.createResource(resourceName, libraryName);
        if (this.activated && resource != null && libraryName != null && LIBRARY.equals(libraryName)) {
            if (ProjectStageProducer.getInstance().getProjectStage() == ProjectStage.Development) {
                resource = this.wrapped.createResource(resourceName, LIBRARY_UNCOMPRESSED);
            }
            resource = new DeltaSpikeResource((Resource)resource, this.version);
        }
        return resource;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }
}

