/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.exception.control;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.exception.control.event.ExceptionToCatchEvent;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.apache.deltaspike.jsf.impl.util.SecurityUtils;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.ErrorViewAwareAccessDeniedException;

public class BridgeExceptionHandlerWrapper
extends ExceptionHandlerWrapper
implements Deactivatable {
    private final ExceptionHandler wrapped;
    private final BeanManager beanManager;
    private final Annotation exceptionQualifier;

    public BridgeExceptionHandlerWrapper(ExceptionHandler wrapped, BeanManager beanManager, Annotation exceptionQualifier) {
        this.wrapped = wrapped;
        this.beanManager = beanManager;
        this.exceptionQualifier = exceptionQualifier;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null || context.getResponseComplete()) {
            return;
        }
        Iterable exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents();
        if (exceptionQueuedEvents != null && exceptionQueuedEvents.iterator() != null) {
            Iterator iterator = exceptionQueuedEvents.iterator();
            while (iterator.hasNext()) {
                Throwable throwable = ((ExceptionQueuedEvent)iterator.next()).getContext().getException();
                Throwable rootCause = this.getRootCause(throwable);
                if (rootCause instanceof AccessDeniedException) {
                    this.processAccessDeniedException(rootCause);
                    iterator.remove();
                    continue;
                }
                ExceptionToCatchEvent event = new ExceptionToCatchEvent(rootCause, new Annotation[]{this.exceptionQualifier});
                event.setOptional(true);
                this.beanManager.fireEvent((Object)event, new Annotation[0]);
                if (event.isHandled()) {
                    iterator.remove();
                }
                if (!context.getResponseComplete()) continue;
                break;
            }
        }
        super.handle();
    }

    public Throwable getRootCause(Throwable throwable) {
        return JsfUtils.getRootCause(throwable);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        ExceptionQueuedEvent exceptionQueuedEvent;
        FacesContext facesContext;
        if (event instanceof ExceptionQueuedEvent && (facesContext = (exceptionQueuedEvent = (ExceptionQueuedEvent)event).getContext().getContext()).getCurrentPhaseId() == PhaseId.RENDER_RESPONSE && exceptionQueuedEvent.getContext().inBeforePhase()) {
            Throwable exception = this.getRootCause(exceptionQueuedEvent.getContext().getException());
            if (exception instanceof AccessDeniedException) {
                this.processAccessDeniedException(exception);
            } else {
                ExceptionToCatchEvent exceptionToCatchEvent = new ExceptionToCatchEvent(exception);
                exceptionToCatchEvent.setOptional(true);
                this.beanManager.fireEvent((Object)exceptionToCatchEvent, new Annotation[0]);
                if (exceptionToCatchEvent.isHandled()) {
                    return;
                }
            }
        }
        super.processEvent(event);
    }

    private void processAccessDeniedException(Throwable throwable) {
        if (throwable instanceof ErrorViewAwareAccessDeniedException) {
            SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)((AccessDeniedException)throwable));
        } else {
            ErrorViewAwareAccessDeniedException securityException = new ErrorViewAwareAccessDeniedException(((AccessDeniedException)throwable).getViolations(), DefaultErrorView.class);
            SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)securityException);
        }
    }
}

