/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.util.Stack;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;

@ApplicationScoped
public class CdiQueryContextHolder {
    private final ThreadLocal<Stack<CdiQueryInvocationContext>> contextStack = new ThreadLocal();

    public void set(CdiQueryInvocationContext context) {
        if (this.contextStack.get() == null) {
            this.contextStack.set(new Stack());
        }
        this.contextStack.get().push(context);
    }

    @Produces
    public CdiQueryInvocationContext get() {
        if (this.contextStack.get() != null && !this.contextStack.get().isEmpty()) {
            return this.contextStack.get().peek();
        }
        return null;
    }

    public void dispose() {
        if (this.contextStack.get() != null && !this.contextStack.get().isEmpty()) {
            CdiQueryInvocationContext ctx = this.contextStack.get().pop();
            ctx.cleanup();
        }
        if (this.contextStack.get() != null && this.contextStack.get().isEmpty()) {
            this.contextStack.remove();
        }
    }
}

