/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.data.api.EntityGraph;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.graph.EntityGraphHelper;
import org.apache.deltaspike.data.impl.handler.JpaQueryPostProcessor;
import org.apache.deltaspike.data.impl.handler.QueryStringPostProcessor;
import org.apache.deltaspike.data.impl.meta.EntityMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.data.impl.param.Parameters;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.util.EntityUtils;
import org.apache.deltaspike.data.impl.util.bean.DependentProviderDestroyable;
import org.apache.deltaspike.data.impl.util.bean.Destroyable;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

public class CdiQueryInvocationContext
implements QueryInvocationContext {
    private final EntityManager entityManager;
    private final Parameters params;
    private final Object proxy;
    private final Method method;
    private final Object[] args;
    private final RepositoryMetadata repositoryMetadata;
    private final RepositoryMethodMetadata repositoryMethodMetadata;
    private final List<QueryStringPostProcessor> queryPostProcessors;
    private final List<JpaQueryPostProcessor> jpaPostProcessors;
    private final List<Destroyable> cleanup;
    private String queryString;

    public CdiQueryInvocationContext(Object proxy, Method method, Object[] args, RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata repositoryMethodMetadata, EntityManager entityManager) {
        this.proxy = proxy;
        this.method = method;
        this.args = args == null ? new Object[]{} : args;
        this.repositoryMetadata = repositoryMetadata;
        this.repositoryMethodMetadata = repositoryMethodMetadata;
        this.entityManager = entityManager;
        this.params = Parameters.create(method, this.args, repositoryMethodMetadata);
        this.queryPostProcessors = new LinkedList<QueryStringPostProcessor>();
        this.jpaPostProcessors = new LinkedList<JpaQueryPostProcessor>();
        this.cleanup = new LinkedList<Destroyable>();
    }

    public void init() {
        if (this.hasQueryInOutMapper()) {
            QueryInOutMapper<?> mapper = this.getQueryInOutMapper();
            this.params.applyMapper(mapper);
            for (int i = 0; i < this.args.length; ++i) {
                if (!mapper.mapsParameter(this.args[i])) continue;
                this.args[i] = mapper.mapParameter(this.args[i]);
            }
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isNew(Object entity) {
        try {
            Property<Serializable> versionProperty = this.repositoryMetadata.getEntityMetadata().getVersionProperty();
            if (versionProperty != null) {
                return versionProperty.getValue(entity) == null;
            }
            Property<Serializable> primaryKeyProperty = this.repositoryMetadata.getEntityMetadata().getPrimaryKeyProperty();
            if (EntityUtils.primaryKeyValue(entity, primaryKeyProperty) == null) {
                return true;
            }
            return !this.entityManager.contains(entity) && this.countCheck(entity, primaryKeyProperty);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Class<?> getEntityClass() {
        return this.repositoryMetadata.getEntityMetadata().getEntityClass();
    }

    public Class<?> getRepositoryClass() {
        return this.repositoryMetadata.getRepositoryClass();
    }

    public Object proceed() throws Exception {
        return this.method.invoke(this.proxy, this.args);
    }

    public Method getMethod() {
        return this.method;
    }

    public Query applyRestrictions(Query query) {
        QueryHint[] hints;
        LockModeType lockMode;
        Parameters params = this.getParams();
        Method method = this.getMethod();
        if (params.hasSizeRestriction()) {
            query.setMaxResults(params.getSizeRestriciton());
        }
        if (params.hasFirstResult()) {
            query.setFirstResult(params.getFirstResult());
        }
        if ((lockMode = this.extractLockMode()) != null) {
            query.setLockMode(lockMode);
        }
        if ((hints = this.extractQueryHints()) != null) {
            for (QueryHint hint : hints) {
                query.setHint(hint.name(), (Object)hint.value());
            }
        }
        this.applyEntityGraph(query, method);
        query = this.applyJpaQueryPostProcessors(query);
        return query;
    }

    public Object[] getMethodParameters() {
        return this.args;
    }

    public void addQueryStringPostProcessor(QueryStringPostProcessor postProcessor) {
        this.queryPostProcessors.add(postProcessor);
    }

    public void addJpaQueryPostProcessor(JpaQueryPostProcessor postProcessor) {
        this.jpaPostProcessors.add(postProcessor);
    }

    public void removeJpaQueryPostProcessor(JpaQueryPostProcessor postProcessor) {
        this.jpaPostProcessors.remove(postProcessor);
    }

    public boolean hasQueryStringPostProcessors() {
        return !this.queryPostProcessors.isEmpty();
    }

    public String applyQueryStringPostProcessors(String queryString) {
        String result = queryString;
        for (QueryStringPostProcessor processor : this.queryPostProcessors) {
            result = processor.postProcess(result);
        }
        return result;
    }

    public Query applyJpaQueryPostProcessors(Query query) {
        Query result = query;
        for (JpaQueryPostProcessor processor : this.jpaPostProcessors) {
            result = processor.postProcess(this, result);
        }
        return result;
    }

    public void addDestroyable(Destroyable destroyable) {
        this.cleanup.add(destroyable);
    }

    public void cleanup() {
        for (Destroyable destroy : this.cleanup) {
            destroy.destroy();
        }
        this.cleanup.clear();
    }

    public Object executeQuery(Query jpaQuery) {
        return this.repositoryMethodMetadata.getQueryProcessor().executeQuery(jpaQuery, this);
    }

    public Parameters getParams() {
        return this.params;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public List<QueryStringPostProcessor> getQueryStringPostProcessors() {
        return this.queryPostProcessors;
    }

    public boolean hasQueryInOutMapper() {
        return this.repositoryMethodMetadata.getQueryInOutMapperClass() != null;
    }

    public QueryInOutMapper<?> getQueryInOutMapper() {
        if (this.repositoryMethodMetadata.getQueryInOutMapperClass() == null) {
            return null;
        }
        QueryInOutMapper result = null;
        if (this.repositoryMethodMetadata.isQueryInOutMapperIsNormalScope()) {
            result = (QueryInOutMapper)BeanProvider.getContextualReference(this.repositoryMethodMetadata.getQueryInOutMapperClass(), (Annotation[])new Annotation[0]);
        } else {
            DependentProvider mappedProvider = BeanProvider.getDependent(this.repositoryMethodMetadata.getQueryInOutMapperClass(), (Annotation[])new Annotation[0]);
            result = (QueryInOutMapper)mappedProvider.get();
            this.addDestroyable(new DependentProviderDestroyable(mappedProvider));
        }
        return result;
    }

    public Object getProxy() {
        return this.proxy;
    }

    private LockModeType extractLockMode() {
        org.apache.deltaspike.data.api.Query query = this.getRepositoryMethodMetadata().getQuery();
        if (query != null && query.lock() != LockModeType.NONE) {
            return query.lock();
        }
        return null;
    }

    private QueryHint[] extractQueryHints() {
        org.apache.deltaspike.data.api.Query query = this.getRepositoryMethodMetadata().getQuery();
        if (query != null && query.hints().length > 0) {
            return query.hints();
        }
        return null;
    }

    private void applyEntityGraph(Query query, Method method) {
        EntityGraph entityGraphAnn = method.getAnnotation(EntityGraph.class);
        if (entityGraphAnn == null) {
            return;
        }
        Object graph = EntityGraphHelper.getEntityGraph(this.getEntityManager(), this.repositoryMetadata.getEntityMetadata().getEntityClass(), entityGraphAnn);
        query.setHint(entityGraphAnn.type().getHintName(), graph);
    }

    private boolean countCheck(Object entity, Property<Serializable> primaryKeyProperty) {
        StringBuilder jpql = new StringBuilder("SELECT COUNT(e) FROM " + this.getEntityClass().getSimpleName() + " e ");
        jpql.append("WHERE e.");
        jpql.append(primaryKeyProperty.getName());
        jpql.append(" = :id");
        Query query = this.entityManager.createQuery(jpql.toString());
        query.setParameter("id", EntityUtils.primaryKeyValue(entity, primaryKeyProperty));
        Long result = (Long)query.getSingleResult();
        return Long.valueOf(0L).equals(result);
    }

    public RepositoryMetadata getRepositoryMetadata() {
        return this.repositoryMetadata;
    }

    public EntityMetadata getEntityMetadata() {
        return this.repositoryMetadata.getEntityMetadata();
    }

    public RepositoryMethodMetadata getRepositoryMethodMetadata() {
        return this.repositoryMethodMetadata;
    }
}

