/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.metadata.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.util.BeanUtils;

public class ImmutableInjectionPoint
implements InjectionPoint {
    private final Annotated annotated;
    private final Member member;
    private final Bean<?> declaringBean;
    private final Set<Annotation> qualifiers;
    private final Type type;
    private final boolean isTransient;
    private final boolean delegate;

    public ImmutableInjectionPoint(AnnotatedField<?> field, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean isTransient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        this.type = field.getJavaMember().getGenericType();
        this.isTransient = isTransient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedField<?> field, BeanManager beanManager, Bean<?> declaringBean, boolean isTransient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = BeanUtils.getQualifiers(beanManager, field.getAnnotations());
        this.type = field.getJavaMember().getGenericType();
        this.isTransient = isTransient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean isTransient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        this.isTransient = isTransient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, BeanManager beanManager, Bean<?> declaringBean, boolean isTransient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = BeanUtils.getQualifiers(beanManager, parameter.getAnnotations());
        this.isTransient = isTransient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public Member getMember() {
        return this.member;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

